import ProviderMapBase from "./providers/ProviderMapBase";
import {DrupalMapInterface, ProviderMapInterface} from "../types";
import Location from "./Location";
import MapPoint from "./MapPoint";
import MapIcon from "./MapIcon";
import Subscriber from "./Subscriber";
import SimpleMap from "./modules/simple/SimpleMap";
import MapInstances from "./MapInstances";
import {Marker} from "./Marker";

export default {

  Subscriber: Subscriber,

  Map: ProviderMapBase,

  MapPoint: MapPoint,

  Marker: Marker,

  Location: Location,

  MapIcon: MapIcon,

  instances: new MapInstances(),

  providers: {},

  modules: {
    SimpleMap: SimpleMap,
  },

  getMapRootElement(settings: any): HTMLElement|undefined {
    if (typeof settings.selector !== "undefined") {
      const mapRoot = document.querySelector(settings.selector);

      if (mapRoot instanceof HTMLElement) {
        return mapRoot;
      }
    }
  },

  async getMapModuleAsync(mapRoot: HTMLElement): Promise<ProviderMapInterface> {
    return new Promise((resolve) => {
      let map = this.instances.get(mapRoot);

      if (map) {
        resolve(map);
      }

      mapRoot.addEventListener('createdA12sDrupalMap', (event: CustomEvent) => {
        resolve(event.detail.map);
      }, { once: true });
    });

  }

} as DrupalMapInterface;
