import {
  drupalMap,
  ProviderMapInterface,
  SimpleMapInterface,
} from "../../../types";
import ModuleMapBase from "../ModuleMapBase";

export default class SimpleMap extends ModuleMapBase<number, drupalMap.MarkerInterface> implements SimpleMapInterface {

  /**
   * Construct a new map module.
   *
   * @param {HTMLElement} root The root HTML element, defining the map...
   * @param {ProviderMapInterface} mapObject The map object, depending on the provider ("google", "baidu"...).
   * @param {Partial<drupalMap.Module.SimpleMapOptions>} options
   */
  constructor(protected readonly root: HTMLElement, readonly mapObject: ProviderMapInterface, protected options: Partial<drupalMap.Module.SimpleMapOptions>) {
    super(root, mapObject, options);

    if ('markers' in options && options.markers.length) {
      options.markers.forEach((markerInfo, key) => {
        const marker = new window.DrupalMap.Marker(this, markerInfo);
        this.addMarker(key, marker);
      });
    }
  }

}
