import {drupalMap} from "../types";
import {Marker} from "./Marker";
import LocationMap from "./modules/locations/LocationMap";

export default class Location extends Marker {

  static readonly LOCATION_DATA_ATTRIBUTE_DEFAULT: string = 'a12sLocationsPoint';

  constructor(protected element: HTMLElement, readonly map: LocationMap, protected _data: drupalMap.LocationData) {
    super(map, _data);

    if (!this._enabled) {
      this.element.hidden = true;
    }
  }

  get enabled(): boolean {
    return this._enabled;
  }

  set enabled(enabled) {
    if (enabled !== this._enabled ) {
      if (!enabled) {
        this.element.hidden = true;
      }
      else {
        this.element.hidden = this.map.getOption('hideNotVisibleLocations') ? !(this.map.mapObject.isMarkerVisible(this.marker)) : false;
      }
    }

    super.enabled = enabled;
  }

  updateState(event: Partial<drupalMap.Module.MapMarkerEvent>): void {
    const locationMap = this.map as LocationMap;

    super.updateState(event);
    this.HTMLElement.classList.toggle('active', event.markerIsActive);

    if (event.type === 'enableActiveMarker') {
      const containerPos = locationMap.locationListContainer.getBoundingClientRect();
      const locationPos = this.HTMLElement.getBoundingClientRect();
      locationMap.locationListContainer.scrollTop = locationPos.top - containerPos.top + locationMap.locationListContainer.scrollTop;
    }
  }

  protected getInfoWindowHtml(): HTMLElement {
    const locationContent = document.createElement('div');
    locationContent.classList.add('location-info-window');
    locationContent.innerHTML = this.HTMLElement.innerHTML;
    return locationContent;
  }

  get HTMLElement(): HTMLElement {
    return this.element;
  }

  get data(): drupalMap.LocationData {
    return this._data;
  }

}
