import {drupalMap} from "../types";

/**
 * Represents a list of markers.
 */
export default class MarkerList<K, V extends drupalMap.MarkerInterface> extends Map<K, V> {

//  /**
//   * Returns the map points.
//   *
//   * @return {drupalMap.MapPointInterface[]} - An array containing the map points.
//   */
//  getMapPoints(): drupalMap.MapPointInterface[] {
//    return [...this.values()].reduce((mapPoints, marker) => {
//      if (marker.enabled) {
//        mapPoints.push(marker.mapPoint);
//      }
//
//      return mapPoints;
//    }, [] as drupalMap.MapPointInterface[]);
//  }

  /**
   * Returns the markers.
   *
   * @return {any[]} - An array containing the markers.
   */
  getMarkers(): any[] {
    return [...this.values()].reduce((markers, marker: drupalMap.MarkerInterface) => {
      if (marker.enabled) {
        markers.push(marker.marker);
      }

      return markers;
    }, [] as any[]);
  }

}
