<?php

namespace Drupal\a12s_maps_sync\Maps;

use Drupal\a12s_maps_sync\Entity\ConverterInterface;
use Drupal\a12s_maps_sync\Entity\ProfileInterface;

/**
 * Interface ObjectInterface
 *
 * This interface represents the contract for an object.
 */
interface ObjectInterface extends BaseInterface {

  /**
   * Get the parent object ID.
   *
   * @return int
   */
  public function getParentId(): int;

  /**
   * Get the source object ID.
   *
   * @return int
   */
  public function getSourceId(): int;

  /**
   * Get the object code.
   *
   * @return string
   */
  public function getCode(): string;

  /**
   * Get the nature ID.
   *
   * @return string
   */
  public function getNature(): string;

  /**
   * Get the type ID.
   *
   * @return string
   */
  public function getType(): string;

  /**
   * Get the object classes.
   *
   * @return array
   */
  public function getClasses(): array;

  /**
   * Get the status ID.
   *
   * @return string
   */
  public function getStatus(): string;

  /**
   * Get the sequence.
   *
   * @return int
   */
  public function getSequence(): int;

  /**
   * get the configuration type.
   *
   * @return string|null
   */
  public function getConfigType(): ?string;

  /**
   * @return array
   */
  public function getMedias(): array;

  /**
   * @param array $medias
   *
   * @return \Drupal\a12s_maps_sync\Maps\ObjectInterface
   */
  public function setMedias(array $medias): ObjectInterface;

  /**
   * @return array
   */
  public function getLinks(?int $linkTypeId, ?bool $useQuantityAsSequence): array;

  /**
   * @param array $links
   *
   * @return \Drupal\a12s_maps_sync\Maps\ObjectInterface
   */
  public function setLinks(array $links): ObjectInterface;

  /**
   * Retrieves the properties associated with the current object.
   *
   * @return array An array containing the properties of the object.
   */
  public function getProperties(): array;

  /**
   * Sets the properties for the current object.
   *
   * @param array $properties An array containing the properties to be set.
   * @return ObjectInterface The updated object with the new properties set.
   */
  public function setProperties(array $properties): ObjectInterface;

  /**
   * Creates an object instance from the provided API data.
   *
   * @param \Drupal\a12s_maps_sync\Entity\ConverterInterface $converter
   * @param array $data An array containing the data retrieved from the API.
   *
   * @return ObjectInterface The object instance created using the API data.
   */
  public static function createFromApiData(ConverterInterface $converter, array $data): ObjectInterface;

}
