<?php

namespace Drupal\a12s_maps_sync\Plugin\MappingHandler;

use Drupal\a12s_maps_sync\Converter\Mapping;
use Drupal\a12s_maps_sync\Entity\ConverterInterface;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\a12s_maps_sync\MapsApiTrait;
use Drupal\a12s_maps_sync\Plugin\MappingHandlerPluginBase;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Language\LanguageInterface;

/**
 * Plugin implementation of the a12s_maps_sync_mapping_handler.
 *
 * @MappingHandler(
 *   id = "media",
 *   label = @Translation("Media"),
 *   description = @Translation("Media.")
 * )
 */
class MediaHandler extends EntityReferenceHandler {

  use MapsApiTrait;

  /**
   * {@inheritdoc}
   */
  public function mapData(EntityInterface $entity, BaseInterface $object, Mapping $mapping, int $mapsLanguage, ?LanguageInterface $language = NULL) {
    if ($mapping->isAppend()) {
      $entity->{$mapping->getTarget()} = [];
    }

    $values = [];

    foreach ($mapping->getConverters() as $targetConverter) {

      // First we load the converter.
      if ($targetConverter !== NULL) {
        // Check if the media pass the converter filters.
        // We need to re-retrieve medias for the converter, since some medias
        // may have been deleted, or some medias may not pass the converter
        // conditions anymore.

        $filters = $targetConverter->getFiltersArray();
        $filters['object_id'] = [
          'filtering_type' => 'value',
          'value' => $object->getId(),
        ];
        $medias = $this->mapsApi()->getMedias($targetConverter, $filters);

        // Get the medias for the current profile.
        if (!empty($medias)) {
          foreach ($medias as $media) {
            $array = [
              'id' => $media['id'],
              'profile' => $targetConverter->getProfile()->id(),
              'converter' => $targetConverter->id(),
            ];

            // Try to load the target entity.
            if ($gid = $this->getGidFromArray($targetConverter->getGid(), $array)) {
              $storage = \Drupal::service('entity_type.manager')
                ->getStorage('media');
              $entities = $storage->loadByProperties([BaseInterface::GID_FIELD => $gid]);

              if (!empty($entities)) {
                // Set the field value.
                $target_entity = reset($entities);
                $values[] = ['target_id' => $target_entity->id()];
              }
            }
          }
        }
      }
    }

    $entity->{$mapping->getTarget()} = $values;

    return $values;
  }

  /**
   * {@inheritdoc}
   */
  public function getObjectValue(ConverterInterface $converter, BaseInterface $object, Mapping $mapping, int $i) {
    return $object->get('medias')[$i]->getId();
  }

}
