<?php

namespace Drupal\a12s_maps_sync\Maps;

/**
 * Class MapsAttribute
 */
class Attribute implements AttributeInterface {

  /**
   * @param string $code
   * @param array $values
   */
  public function __construct(
    protected string $code,
    protected array $values = [],
    protected array $data = [],
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getCode(): string {
    return $this->code;
  }

  /**
   * {@inheritdoc}
   */
  public function setCode(string $code): Attribute {
    $this->code = $code;
    return $this;
  }

  /**
   * @return array
   */
  public function getData(): array {
    return $this->data;
  }

  /**
   * @param array $data
   *
   * @return Attribute
   */
  public function setData(array $data): Attribute {
    $this->data = $data;
    return $this;
  }

  /**
   * Set value for a specific delta.
   *
   * @param $value
   * @param int $delta
   * @param int $language_id
   * @param array $data
   *
   * @return \Drupal\a12s_maps_sync\Maps\Attribute
   */
  public function setValue($value, int $language_id, int $delta = 0, array $data = []): Attribute {
    // @todo how to handle sequence?
    $this->values[$delta][$language_id] = ['value' => $value] + $data;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getValue(int $language_id, int $delta = 0) {
    return $this->values[$delta][$language_id] ?? NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getCountValue(): int {
    return count($this->values);
  }

}
