<?php

namespace Drupal\a12s_maps_sync\Plugin\SourceHandler;

use Drupal\a12s_maps_sync\Entity\ConverterInterface;
use Drupal\a12s_maps_sync\Maps\MapsObject as MapsObjectBase;
use Drupal\a12s_maps_sync\Plugin\SourceHandlerPluginBase;

/**
 * Plugin implementation of the a12s_maps_sync_source_handler.
 *
 * @SourceHandler(
 *   id = "object",
 *   label = @Translation("Object"),
 *   description = @Translation("Object.")
 * )
 */
class MapsObject extends SourceHandlerPluginBase {

  use AttributesTrait;

  /**
   * {@inheritdoc}
   * @param \Drupal\a12s_maps_sync\Entity\ConverterInterface $converter
   */
  public function getFilterTypes(ConverterInterface $converter): array {
    $filterTypes = [
      'object_nature' => $this->t('Object nature'),
      'object_type' => $this->t('Object type'),
      'class' => $this->t('Object class'),
      'parent_id' => $this->t('Parent ID'),
    ];

    // Get the available object properties.
    $properties = $this->mapsApi()->getObjectProperties($converter->getProfile(), ['type' => 'attribute']);
    foreach ($properties as $property) {
      $filterTypes['Properties'][$property] = $property;
    }
    if (!empty($filterTypes['Properties'])) {
      asort($filterTypes['Properties']);
    }

    $filterTypes['Attributes'] = $this->getAttributesFilters($converter);

    return $filterTypes;
  }

  /**
   * {@inheritdoc}
   */
  public function getCountData(ConverterInterface $converter, array $filters, int $fromTime): int {
    return $this->mapsApi()->getObjects($converter->getProfile(), $filters, -1, $fromTime, TRUE);
  }

  /**
   * {@inheritdoc}
   */
  public function getData(ConverterInterface $converter, array $filters, int $limit, int $fromTime = 0): array {
    $data = $this->mapsApi()->getObjects($converter->getProfile(), $filters, $limit, $fromTime);
    $return = [];

    foreach ($data as $datum) {
      $object = MapsObjectBase::createFromApiData($converter, $datum);
      $return[] = $object;
    }

    return $return;
  }

  /**
   * {@inheritdoc}
   */
  public function getMappingSources(): array {
    return [
      'Properties' => [
        'id' => $this->t('ID'),
        'source_id' => $this->t('Origin ID'),
        'parent_id' => $this->t('Parent ID'),
        'code' => $this->t('Code'),
        'sequence' => $this->t('Sequence'),
        'medias' => $this->t('Medias'),
        'links' => $this->t('Links'),
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getAllowedGidEntityKeys(): array {
    return ['id', 'source_id', 'code'];
  }

}
