<?php

namespace Drupal\a12s_maps_sync;

final class StateQueueItem {

  /**
   * The profile id.
   *
   * @var string
   */
  private string $profile;

  /**
   * The converter id.
   *
   * @var string|null
   */
  private ?string $converter;

  /**
   * The time when the item has been created.
   *
   * @var int
   */
  private int $timestamp;

  /**
   * Additional options.
   *
   * @var array
   */
  private array $options = [];

  /**
   * @param string $profile
   * @param string|null $converter
   */
  public function __construct(string $profile, ?string $converter = NULL) {
    $this->profile = $profile;
    $this->converter = $converter;
    $this->timestamp = time();
  }

  /**
   * Get the queue key.
   *
   * @return string
   */
  public function getQueueKey(): string {
    $key = $this->profile;
    if (!is_null($this->converter)) {
      $key .= ':' . $this->converter;
    }

    return $key;
  }

  /**
   * @return string
   */
  public function getProfile(): string {
    return $this->profile;
  }

  /**
   * @return string|null
   */
  public function getConverter(): ?string {
    return $this->converter;
  }

  /**
   * @return int
   */
  public function getTimestamp(): int {
    return $this->timestamp;
  }

  /**
   * @return array
   */
  public function getOptions(): array {
    return $this->options;
  }

  /**
   * Convert to an array.
   * Useful for displaying or debugging.
   *
   * @return string[]
   */
  public function toArray(): array {
    return [
      'profile' => $this->profile,
      'converter' => $this->converter,
      'timestamp' => date('Y-m-d H:i:s', $this->timestamp),
    ];
  }

}
