<?php

namespace Drupal\a12s_maps_sync\Maps;

class Library extends Base implements LibraryInterface {

  /**
   * @var string
   */
  protected string $code;

  /**
   * @var int
   */
  protected int $id_attribute;

  /**
   * @var array
   */
  protected array $value;

  /**
   * @param int $id
   * @param string $profile
   * @param string $code
   * @param int $id_attribute
   * @param array $value
   * @param int $imported
   */
  public function __construct(int $id, string $profile, string $code, int $id_attribute, array $value, int $imported) {
    $this->id = $id;
    $this->profile = $profile;
    $this->code = $code;
    $this->id_attribute = $id_attribute;
    $this->value = $value;
    $this->imported = (int) $imported;
  }

  /**
   * {@inheritdoc}
   */
  public function getCode(): string {
    return $this->code;
  }

  /**
   * {@inheritdoc}
   */
  public function setCode(string $code): Library {
    $this->code = $code;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getIdAttribute(): int {
    return $this->id_attribute;
  }

  /**
   * {@inheritdoc}
   */
  public function setIdAttribute(int $id_attribute): Library {
    $this->id_attribute = $id_attribute;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getValueByLanguage(int $id_language): ?string {
    return !empty($this->value[$id_language]) ? $this->value[$id_language] : NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function setValueByLanguage(int $id_language, string $value): Library {
    $this->value[$id_language] = $value;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getValue(int $id_language = NULL) {
    if ($id_language !== NULL) {
      return $this->getValueByLanguage($id_language);
    }
    return $this->value;
  }

  /**
   * {@inheritdoc}
   */
  public function setValue(array $value): Library {
    $this->value = $value;
    return $this;
  }

  /**
   * {@inheritDoc}
   */
  public function get(string $name, int $language_id = NULL, $delta = NULL) {
    $properties = [
      'id',
      'profile',
      'converter',
      'code',
      'id_attribute',
      'id_language',
    ];

    if (in_array($name, $properties)) {
      return $this->{$name};
    }

    if ($name === 'value') {
      return $this->getValue($language_id);
    }
  }

  /**
   * {@inheritDoc}
   */
  public function getCountValues(string $name): int {
    return 1;
  }

}
