<?php

namespace Drupal\a12s_maps_sync\Plugin\MappingHandler;

use Drupal\a12s_maps_sync\Converter\Mapping;
use Drupal\a12s_maps_sync\Entity\ConverterInterface;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\a12s_maps_sync\Plugin\MappingHandlerPluginBase;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Language\LanguageInterface;

/**
 * Plugin implementation of the a12s_maps_sync_mapping_handler.
 *
 * @MappingHandler(
 *   id = "entity_reference_revision",
 *   label = @Translation("Entity Reference revision"),
 *   description = @Translation("Entity Reference revision.")
 * )
 */
class EntityReferenceRevisionHandler extends EntityReferenceHandler {

  /**
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *
   * @return array
   */
  protected function getValue(EntityInterface $entity) {
    return [
      'target_id' => $entity->id(),
      'target_revision_id' => $entity->getRevisionId(),
    ];
  }

}
