<?php

namespace Drupal\a12s_maps_sync\Entity;

use Drupal\Core\Entity\ContentEntityBase;

/**
 * Defines the contextualized attribute entity class.
 *
 * @ContentEntityType(
 *   id = "contextualized_attribute",
 *   label = @Translation("Contextualized Attribute"),
 *   label_collection = @Translation("Contextualized Attributes"),
 *   label_singular = @Translation("contextualized attribute"),
 *   label_plural = @Translation("contextualized attributes"),
 *   label_count = @PluralTranslation(
 *     singular = "@count contextualized attributes",
 *     plural = "@count contextualized attributes",
 *   ),
 *   bundle_label = @Translation("Contextualized Attribute type"),
 *   handlers = {
 *     "list_builder" = "Drupal\a12s_maps_sync\ContextualizedAttributeListBuilder",
 *     "views_data" = "Drupal\views\EntityViewsData",
 *     "access" = "Drupal\a12s_maps_sync\ContextualizedAttributeAccessControlHandler",
 *     "form" = {
 *       "add" = "Drupal\a12s_maps_sync\Form\ContextualizedAttributeForm",
 *       "edit" = "Drupal\a12s_maps_sync\Form\ContextualizedAttributeForm",
 *       "delete" = "Drupal\Core\Entity\ContentEntityDeleteForm",
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\a12s_maps_sync\Routing\ContextualizedAttributeHtmlRouteProvider",
 *     }
 *   },
 *   base_table = "contextualized_attribute",
 *   admin_permission = "administer contextualized attribute types",
 *   entity_keys = {
 *     "id" = "id",
 *     "bundle" = "bundle",
 *     "label" = "id",
 *     "uuid" = "uuid",
 *   },
 *   links = {
 *     "collection" = "/admin/a12s_maps_sync/contextualized-attribute",
 *     "add-form" = "/admin/a12s_maps_sync/contextualized-attribute/add/{contextualized_attribute_type}",
 *     "add-page" = "/admin/a12s_maps_sync/contextualized-attribute/add",
 *     "canonical" = "/admin/a12s_maps_sync/contextualized-attribute/{contextualized_attribute}",
 *     "edit-form" = "/admin/a12s_maps_sync/contextualized-attribute/{contextualized_attribute}",
 *     "delete-form" = "/admin/a12s_maps_sync/contextualized-attribute/{contextualized_attribute}/delete",
 *   },
 *   bundle_entity_type = "contextualized_attribute_type",
 *   field_ui_base_route = "entity.contextualized_attribute_type.edit_form",
 * )
 */
class ContextualizedAttribute extends ContentEntityBase implements ContextualizedAttributeInterface {

}
