<?php

namespace Drupal\a12s_maps_sync;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Provides a listing of MaPS Sync profile entities.
 */
class ProfileListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('MaPS Sync profile');
    $header['id'] = $this->t('Machine name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function getOperations(EntityInterface $entity) {
    $operations = parent::getOperations($entity);

    array_unshift($operations, [
      'title' => $this->t('Converters'),
      'url' => Url::fromRoute('entity.maps_sync_converter.collection', ['maps_sync_profile' => $entity->id()]),
    ]);

    $operations['import'] = [
      'title' => $this->t('Import'),
      'url' => $entity->toUrl('import-form'),
    ];

    $operations['attribute-import-wizard'] = [
      'title' => $this->t('Attribute import wizard'),
      'url' => $entity->toUrl('attribute-import-wizard-form'),
    ];

    return $operations;
  }

}
