<?php

namespace Drupal\a12s_maps_sync\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Derives local actions for entity types.
 */
class MapsSyncEntityActionsDeriver extends DeriverBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    if (!$this->derivatives) {
      $route_name = 'entity.maps_sync_converter.add_form';

      $this->derivatives[$route_name] = [
        'title' => $this->t('Add converter'),
        'route_name' => $route_name,
        'appears_on' => ['entity.maps_sync_converter.collection'],
      ];
    }

    return $this->derivatives;
  }

}
