<?php

namespace Drupal\a12s_maps_sync;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of contextualized attribute type entities.
 *
 * @see \Drupal\a12s_maps_sync\Entity\ContextualizedAttributeType
 */
class ContextualizedAttributeTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['title'] = $this->t('Label');

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['title'] = [
      'data' => $entity->label(),
      'class' => ['menu-label'],
    ];

    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();

    $build['table']['#empty'] = $this->t(
      'No contextualized attribute types available. <a href=":link">Add contextualized attribute type</a>.',
      [':link' => Url::fromRoute('entity.contextualized_attribute_type.add_form')->toString()]
    );

    return $build;
  }

}
