<?php

namespace Drupal\a12s_maps_sync\Form;

use Drupal\a12s_maps_sync\BatchService;
use Drupal\a12s_maps_sync\Entity\ProfileInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Class ProfileImportForm.
 */
class ProfileImportForm extends ImportForm {

  /**
   * Title callback.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup
   */
  public function title(): TranslatableMarkup {
    return $this->t("Import profile %profile", ['%profile' => \Drupal::request()->get('maps_sync_profile')->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function import(array $form, FormStateInterface $form_state): void {
    /** @var ProfileInterface $profile */
    $profile = $this->entity;

    if ($form_state->getValue('import_type') === 'full') {
      foreach ($profile->getConverters() as $converter) {
        $converter->resetLastImportedTime();
      }
    }

    $batch = BatchService::getProfileImportBatchDefinition(
      $profile,
      $form_state->getValue('batch_size', 0),
    );

    batch_set($batch);
  }

}
