<?php

namespace Drupal\a12s_maps_sync\Plugin;

use Drupal\a12s_maps_sync\Converter\Mapping;
use Drupal\a12s_maps_sync\Entity\ConverterInterface;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Language\LanguageInterface;
use Drupal\Core\Plugin\PluginFormInterface;

/**
 * Interface for a12s_maps_sync_mapping_handler plugins.
 */
interface MappingHandlerInterface extends ConfigurableInterface, PluginFormInterface, PluginInspectionInterface {

  /**
   * @param \Drupal\Core\Entity\EntityInterface $entity
   * @param \Drupal\a12s_maps_sync\Maps\BaseInterface $object
   * @param \Drupal\a12s_maps_sync\Converter\Mapping $mapping
   * @param int $mapsLanguage
   * @param \Drupal\Core\Language\LanguageInterface|null $language
   *
   * @return mixed
   */
  public function mapData(EntityInterface $entity, BaseInterface $object, Mapping $mapping, int $mapsLanguage, ?LanguageInterface $language = NULL);

  /**
   * @param $value
   * @return mixed
   */
  public function castValue($value);

  /**
   * Get additional field parameters (like format or whatever).
   *
   * @return array
   */
  public function getAdditionalFieldParameters(): array;

  /**
   * Checks if it is a multiple mapping.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   * @param \Drupal\a12s_maps_sync\Converter\Mapping $mapping
   *
   * @return bool
   */
  public function isMultiple(EntityInterface $entity, Mapping $mapping): bool;

}
