<?php

namespace Drupal\a12s_maps_sync\Converter;

class Filter {

  /**
   * @param string $type
   * @param string|null $value
   */
  public function __construct(
    protected string $type,
    protected ?string $value,
    protected ?string $filtering_type,
  ) {}

  /**
   * @return string
   */
  public function getType(): string {
    return $this->type;
  }

  /**
   * @param string $type
   *
   * @return Filter
   */
  public function setType(string $type): Filter {
    $this->type = $type;
    return $this;
  }

  /**
   * @return string|null
   */
  public function getValue(): ?string {
    return $this->value;
  }

  /**
   * @param string $value
   *
   * @return Filter
   */
  public function setValue(string $value): Filter {
    $this->value = $value;
    return $this;
  }

  /**
   * @return string|null
   */
  public function getFilteringType(): ?string {
    return $this->filtering_type;
  }

  /**
   * @param string|null $filtering_type
   *
   * @return $this
   */
  public function setFilteringType(?string $filtering_type): Filter {
    $this->filtering_type = $filtering_type;
    return $this;
  }

}
