<?php

namespace Drupal\a12s_maps_sync\Form;

use Drupal\Core\Entity\EntityForm;
use Drupal\Core\Form\FormStateInterface;

abstract class ImportForm extends EntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state): array {
    $form = parent::form($form, $form_state);

    $form['warning'] = [
      '#markup' => $this->t('The differential import will only import new data. The full import will erase the stored timestamp of last import, and process a full import'),
    ];

    $form['import_type'] = [
      '#type' => 'select',
      '#title' => $this->t('Import type'),
      '#options' => [
        'diff' => $this->t('Differential import'),
        'full' => $this->t('Full import'),
      ],
    ];

    $form['batch_size'] = [
      '#type' => 'number',
      '#title' => $this->t('Batch size'),
      '#default_value' => \Drupal::config('a12s_maps_sync.settings')->get('import_batch_size'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  protected function actions(array $form, FormStateInterface $form_state) {
    return [
      'submit' => [
        '#type' => 'submit',
        '#value' => $this->t('Import'),
        '#submit' => ['::submitForm', '::import'],
      ]
    ];
  }

}
