<?php

namespace Drupal\a12s_maps_sync\Plugin\MappingHandler;

use Drupal\a12s_maps_sync\Converter\Mapping;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Language\LanguageInterface;

/**
 * Plugin implementation of the a12s_maps_sync_mapping_handler.
 *
 * @MappingHandler(
 *   id = "integer",
 *   label = @Translation("Integer"),
 *   description = @Translation("Integer.")
 * )
 */
class IntegerHandler extends DefaultHandler {

  /**
   * {@inheritdoc}
   */
  public function castValue($value) {
    return $value ? (int) $value : NULL;
  }

}
