# a12s MaPS Sync

1. [Introduction](#introduction)
2. [Service Python](#service-python)
   1. [Configuration de la base de données du service Python](#configuration-de-la-base-de-données-du-service-python)
   2. [Fonctionnement du service Python](#fonctionnement-du-service-python)
   3. [Watcher](#watcher)
   4. [API](#api)
      1. [Démarrage de l'API](#démarrage-de-lapi)
      2. [Authentification](#authentification)
      3. [Collection Postman](#collection-postman)
      4. [Définitions des endpoints](#définitions-des-endpoints)
3. [Module Drupal a12s MaPS Sync](#module-drupal-a12s_maps_sync)
  1. [Installation du module](#installation-du-module)
  2. [Configuration du module](#configuration-du-module)
     1. [Configurer les types d'entités autorisés](#configurer-les-types-dentités-autorisés)
     2. [Configuration des profils](#configuration-des-profils)
     3. [Configuration des convertisseurs](#configuration-des-convertisseurs)
     4. [Gestion des filtres](#gestion-des-filtres)
     5. [Gestion du mapping](#gestion-du-mapping)
  3. [Import des données](#import-des-données)
  4. [Auto-configuration](#auto-configuration)
  5. [Gestion des attributs critérisés](#gestion-des-attributs-critérisés)
  6. [Commandes disponibles](#commandes-disponibles)
     1. [Importer un profil](#importer-un-profil)
     2. [Importer un convertisseur](#importer-un-convertisseur)
     3. [Lancer l'auto-configuration](#lancer-lauto-configuration)
     4. [Importer une entité](#importer-une-entité)
     5. [Importer un objet / media](#importer-un-objet--media)
     6. [Rollback un profil](#rollback-un-profil)
     7. [Rollback un convertisseur](#rollback-un-convertisseur)
     8. [Libérer un lock](#libérer-un-lock)
  7. [Exemples de mappings complexes](#exemples-de-mappings-complexes)
     1. [Mapping d'un attribut objet](#mapping-dun-attribut-objet)
     2. [Mapping d'un attribut librairie](#mapping-dun-attribut-librairie)
  8. [Annexes](#annexes)
     1. [Intégration avec Monolog](#integration-avec-monolog)

## Introduction

Les flux sont importés grâce à un service Python qui stocke les données dans une table à part.
Le module Drupal lit ensuite ces données via une API afin de créer les entités correspondantes dans Drupal.

## Service Python

### Configuration de la base de données du service Python

Configurer les variables d'environnement suivantes :

```
# La configuration de la base de données
DB_DATABASE=
DB_PORT=3306
DB_USERNAME=
DB_PASSWORD=
DB_ROOT_PASSWORD=
DB_HOST=

# Le chemin vers les fichiers MaPS
MAPS_FILES_PATH=/app/maps

# Le chemin vers l'application Flask
FLASK_APP=/app/scripts/api.py
```

### Fonctionnement du service Python

Le service Python est lui-même composé de 2 services :
- Un *watcher*, qui détecte les modifications sur les flux MaPS, et importe leurs données
- Une *API* qui expose les données importées

### Watcher

Le *watcher* est un service qui tourne en continue, et qui détecte les modifications sur les flux MaPS. Dès qu'une
modification est apportée, le *watcher* parcourt ces flux et extrait les données pour les ordonner et les stocker dans
la base de données.

Le *watcher* est lancé via la commande `python watch.py` dans le dossier `/app/scripts`.

### API

L'API, développée grâce au framework Flask, permet d'acceder aux données importées par le *watcher*.

#### Démarrage de l'API

Ce service est lancé
- en développement : via la commande `python watch.py` dans le dossier `/app/scripts`.
- via la commande `flask run`

#### Authentification

à définir

#### Collection Postman

@todo

https://interstellar-crater-9095.postman.co/workspace/A%C3%AFon-Solutions~eab0bae8-eb7e-45c9-b010-14a9cdb3f190/collection/1079669-582ec17c-bf42-48f8-b9d9-58b295bda5be?action=share&creator=1079669&active-environment=1079669-43926d04-be87-44fe-ae06-2cba4191e4ac

#### Définitions des endpoints

Tous les appels à l'API se font en `GET`.

Chaque endpoint nécessite de spécifier le nom du profil concerné (le nom du profil correspond au nom machine utilisé
pour nommer les flux).

Lorsque le endpoint accepte un paramètre `Filtres`, ce paramètre est toujours un tableau de la forme
`[condition1 => valeur1, condition2 => valeur2]`, et les valeurs acceptées sont précisées dans la définition du
paramètre

##### Récupérer la configuration

- **Endpoint** : `/api/v1/<profile>/config`
- **Paramètres disponibles** :
  - `filters` (`id`, `code`, `type`, `id_language`)
- **Exemple de retour** :
```
[
  {
    "id": 425,
    "code": "LABEL_CRM",
    "value": "LABEL_CRM",
    "id_language": 148,
    "type": "attribute",
    "profile": "collections",
    "imported": 1701963962912,
    "data": {
      "idattribute_type": "2",
      "attribute_type_code": "string",
      "localisable": true,
      "multiple": false,
      "metaclass": "GENERAL"
    }
  }
]
```

##### Récupérer les objets

Récupère une liste d'objets avec leurs attributs, médias et liens.

- **Endpoint** : `/api/v1/<profile>/objects`
- **Paramètres disponibles** :
  - `filters` (`id`, `parent_id`, `source_id`, `code`, `nature`, `type`, `status`)
  - `from_time` : Timestamp permettant de récupérer les objets ajoutés / modifiés depuis une date donnée
  - `limit` : Limite le nombre de résultats retournés
- **Exemple de retour** :
```
[
  {
    "id": 130102,
    "profile": "collections",
    "parent_id": 130101,
    "source_id": 130102,
    "code": "C902",
    "nature": 4,
    "type": 21,
    "status": 8,
    "sequence": 1,
    "config_type": null,
    "hash": "65500ea3acb703844aa5b4d76376fbfc",
    "imported": 1701879001108,
    "classes": [
      20
    ],
    "medias": [
      {
        "id": 111,
        "profile": "collections",
        "extension": "jpg",
        "type": "1",
        "url": "https://maps-system.my-project.com/media/mid/1/111.jpg",
        "weight": 6,
        "filename": "my-media-111.jpg",
        "updated": 0,
        "imported": 1701879001,
        "attributes": {
          "MEDTYPEIMG": {
            "values": {
              "1": {
                "0": "SM"
              }
            },
            "data": {
              "0": {
                "idattribute_library": "963",
                "code": "SM"
              }
            }
          },
        }
      }
    ],
    "links": [
      {
        "profile": "collections",
        "type_id": 5,
        "source_id": 130102,
        "target_id": 130108,
        "count": 1,
        "imported": 1701962942308
      }
    ],
    "attributes": {
      "LABEL": {
        "values": {
          "2": {
            "0": "My product"
          }
        },
        "data": {
          "0": {
            "idlanguage": "2",
            "language": "EN",
            "locale": "en_GB"
          }
        }
      },
      "HEIGHT": {
        "values": {
          "1": {
            "0": "7.75"
          }
        },
      },
      "WARRENTY": {
        "values": {
          "1": {
            "0": "WARRANTY_3"
          }
        },
        "data": {
          "0": {
            "idattribute_library": "343",
            "code": "WARRANTY_3"
          }
        }
      },
      "CASE": {
        "values": {
          "1": {
            "0": "123456",
            "1": "123457",
          }
        },
        "data": {
          "1": {
            "objectCode": "PICTO-M5"
          },
          "0": {
            "objectCode": "PICTO-M1"
          },
        }
      },
    }
  }
]
```

##### Récupérer les médias

- **Endpoint** : `/api/v1/<profile>/medias`
- **Paramètres disponibles** :
  - `filters` (`id`, `extension`, `type`, `object_id`)
  - `from_time` : Timestamp permettant de récupérer les médias ajoutés / modifiés depuis une date donnée
  - `limit` : Limite le nombre de résultats retournés
- **Exemple de retour** :
```
[
  {
    "id": 7668,
    "profile": "collections",
    "extension": "tif",
    "type": "1",
    "url": "https://maps-system.my-project.com/media/mid/1/112.jpg",
    "weight": 1,
    "filename": "my-media-112.png",
    "updated": 0,
    "imported": 1701879001,
    "attributes": {
      "MEDIAIMGTYPE": {
        "values": {
          "1": {
            "0": "PRINCIPALE",
            "1": "SOLDAT_SFAMILY"
          }
        },
        "data": {
          "0": {
            "idattribute_library": "1",
            "code": "PRINCIPALE"
          },
          "1": {
            "idattribute_library": "135",
            "code": "SOLDAT_SFAMILY"
          }
        }
      },
      "USED_IN_WEB": {
        "values": {
          "1": {
            "0": "1"
          }
        },
      }
    }
  }
]
```

##### Récupérer les liens

- **Endpoint** : `/api/v1/<profile>/links`
- **Paramètres disponibles** :
  - `filters` (`source_id`, `target_id`, `type_id`)
  - `ordered` : Retourne les liens ordonnées en fonction de leur `count` ("hack" chez MaPS pour gérer les séquences
    sur les liens)
- **Exemple de retour** :
```
[
  {
    "profile": "collections",
    "type_id": 5,
    "source_id": 138039,
    "target_id": 138051,
    "count": 1,
    "imported": 1701962939304
  }
]
```

##### Récupérer les librairies

- **Endpoint** : `/api/v1/<profile>/libraries/<idattribute>`
- **Arguments** :
  - `idattribute` : l'identifiant de l'attribut librairie
- **Paramètres disponibles** :
  - `from_time` : Timestamp permettant de récupérer les librairies ajoutés / modifiés depuis une date donnée
  - `limit` : Limite le nombre de résultats retournés
  - **Exemple de retour** :
```
[
  "349": {
    "id": 349,
    "value": {
      "1": "Couleur",
      "2": "Color",
    },
    "code": "COLOR",
    "profile": "collections",
    "imported": 1701963961198,
    "id_attribute": 5
  }
]
```


## Module Drupal a12s_maps_sync

### Installation du module

Le module s'installe de manière standard :

`drupal module:install a12s_maps_sync`

### Configuration du module

#### Configurer les types d'entités autorisés

Il est nécessaire de définir au préalable les types d'entités autorisés, afin de créer dynamiquement le champ GID MaPS,
utilisé pour faire la correspondance entre les entités Drupal et les objets / médias MaPS.

La configuration se fait à l'adresse */admin/config/a12s_maps_sync/settings*
(Menu *MaPS Sync* -> *Settings*).

#### Configuration des profils

Un *Profile* est une entité personnalisé utilisée pour regrouper plusieurs convertisseurs utilisant un même flux.
La plupart du temps, nous aurons donc un profil par flux MaPS.

Pour ajouter un nouveau profil : */admin/a12s_maps_sync/profile*
(Menu *MaPS Sync* -> *Profile* -> *Add MaPS Sync profile*)

**Le nom machine du convertisseur doit correspondre au nom "machine" des flux MaPS**.

La configuration du profil demande de définir l'identifiant (MaPS) de la langue utilisé par défaut dans MaPS.
Ceci est nécessaire car suivant les flux, la langue par défaut n'est pas la même.
Dans la plus grande partie des cas, la langue à choisir sera soit le français (id 1) ou l'anglais (id 2).
Il convient de vérifier dans les flux la langue à utiliser par défaut.

Il est également nécessaire d'indiquer le chemin du dossier dans lequel les médias sont déposés. Le chemin doit être
défini intégralement, en utilisant une URI commençant par *public://* ou *private://*, sans slash à la fin.

*Exemple : `public://maps_suite/collections/medias`*

#### Configuration des convertisseurs

Une fois le profil créé, il est possible de créer des convertisseurs, définissant comment les objets MaPS vont être
convertis dans Drupal.

À partir de la vue d'ensemble des profils (*/admin/a12s_maps_sync/profile*), via l'opération *Converters*,
nous accédons à la vue d'ensemble des convertisseurs de ce profil, à partir de laquelle nous pouvons ajouter un nouveau
convertisseur.

Pour chaque convertisseur, il faut définir les éléments suivants :

* Un **libellé** et un **nom machine**
* Un **"handler"** (par défaut, utiliser le handler *Default*, sauf pour des cas particuliers que nous détaillerons
  plus tard)
* Le **parent** (utilisé pour ordonner les convertisseurs par groupes : "Médias", "Références", ...)
* Le **GID** :  définit comment le "GID" va être généré. Par défaut, le GID est **profile,id**, ce qui veut dire que le
  GID sera composé du nom machine du profile et de l'identifiant de l'objet MaPS. Si besoin, nous pouvons utiliser le préfixe *const:* pour utiliser une constante dans le GID.
* Le **type d'entité** à utiliser pour convertir l'objet MaPS
* Le **bundle** à utiliser pour convertir l'objet MaPS, si besoin
* Le **type de "l'entité MaPS"** : objet, média ou librairie
* Les **statuts publiés** : définit les statuts MaPS à considérer comme "publié" (par exemple, 8 et 4), si besoin. Valeurs séparées par des virgules.
* Le type de **gestion des status** : permet de définir ce que l'on fait des objets non-publiés dans MaPS (suppression ou dépublication)


Les médias MaPS ne possédant aucun status, il est possible de définir, dans le cas d'un convertisseur de média,
une propriété qui fera office de status :
- La **propriété** à utiliser comme status
- La **valeur** de cette propriété pour considérer le média comme étant publié (par exemple, `1`)


Les convertisseurs peuvent être ordonnés à partir de la vue d'ensemble des convertisseurs afin de les ordonner par
groupe et/ou définir dans quel ordre ils doivent être traités lors de l'import d'un profil.

#### Gestion des filtres

Les filtres permettent de définir les contenus à récupérer depuis l'API.

Ces filtres sont dépendants de la configuration du convertisseur. Ainsi ne sont proposés que les filtres ayant un sens
dans le contexte du convertisseur (par exemple, filtrer sur les attributs pour les objets / médias, sur le type ou la
nature pour les objets, ...).

Les filtres sont toujours cumulatifs.


#### Gestion du mapping

Le formulaire de mapping permet d'établir la correspondance entre les attributs MaPS et les champs Drupal.

La configuration minimale d'un mapping comprend forcément les éléments suivants :
- La **source** : l'attribut ou la propriété MaPS à utiliser
- La **destination** : le champ ou la propriété Drupal
- Une option **append**, qui détermine si la valeur doit être ajoutée aux valeurs existantes ou non. Ce paramètre est
  principalement utilisé lorsqu'un champ MaPS doit être renseigné par plusieurs attributs MaPS (cas particulier,
  cette case à cocher peut donc être ignorée la plupart du temps)
- Un **handler** : détermine la manière dont les données doivent être mappées. Ces handlers sont détaillés ci-dessous

##### Gestionnaires de mapping

Différents gestionnaires de mapping (**handler**) permettent de gérer les cas plus complexes de mapping.

###### Default

Permet de gérer les cas de mapping "standards" (entier, chaine de caractères, booléen, ...)

Il ne nécessite pas de configuration supplémentaire.

###### Entity Reference

Permet de gérer les cas de mapping plus complexes, dans lesquels la valeur dans Drupal sera une référence à une autre
entité.

Ce gestionnaire permet principalement de gérer les attributs objets et les attributs librairies.

La configuration de ce gestionnaire nécessite de préciser :
- Le convertisseur utilisé pour importer la donnée à mapper
- Le type d'entité cible : ce paramètre peut être ignoré dans la plupart des cas, car il permet de répondre à des
  problématiques de mapping très spécifique.

###### Entity Reference Revision

Similaire au gestionnaire *Entity Reference*, mais pour les révisions

###### Media

Similaire au gestionnaire *Entity Reference* dans sa configuration, ce gestionnaire permet de gérer le mapping de médias
MaPS.

Dans le cas de ce gestionnaire, il peut être utile de préciser le type d'entité cible (voir exemple dans la partie
*Exemples de mapping complexes*).

###### Link

Permet de gérer le mapping des liens MaPS, en récupérant tous les liens dont l'objet courant est la source.

La configuration est similaire à celle du gestionnaire *Entity Reference*, avec les particularités suivantes :
- **Link type** : Permet de filtrer sur un type de lien donné
- **Use quantity as sequence** : Permet de gérer la séquence des liens MaPS en utilisant l'attribut `count` du lien
  MaPS. C'est une "ruse" utilisée par MaPS System pour contourner le manque de séquence sur les liens.

###### Criteria attribute

Permet de gérer les attributs critérisés, en définissant :
- Le type de **Contextualized attribute**
- Le champ contenant le critère
- Le champ contenant la valeur

La gestion des attributs critérisés est expliquée plus bas dans ce document.

### Import des données

Les données peuvent être importées :
- via le back-office, dans l'onglet *Import* d'un profil ou d'un convertisseur
- via les commandes Drush dédiées (détaillées dans ce document)

### Auto-configuration

L'auto-configuration permet, en se basant sur les sets d'attributs MaPS, de gérer automatiquement la configuration du
mapping d'un convertisseur. Cela inclut :
- La génération des champs dans Drupal
- La configuration du *view display*
- La configuration du *form display*
- La génération du mapping
- La génération des vocabulaires (dans le cas où on a des attributs objets ou des librairies).

Le formulaire permet de définir les sets d'attributs à utiliser pour l'auto-configuration, et d'exclure certains
attributs que l'on souhaite ignorer.

Enfin, nous avons deux possibilités pour gérer les attributs librairies :
- *Entity Reference fields* : les attributs librairies sont convertis en champs Entity Reference vers une taxonomie
(créé à la volée)
- *List fields* : les attributs librairies sont converties en champs *List text*, dont les valeurs disponibles sont les
valeurs de la librairies.

Les attributs objets sont gérées de la même façons que les librairies en mode *Entity Reference fields*

Le nom machine de tout ce qui est généré par l'auto-configuration est prefixé par `maps`.

L'auto-configuration n'est pas lancée automatiquement, mais via une commande Drush (qui peut elle, être intégrée dans
la crontab).


### Gestion des attributs critérisés

Les attributs critérisés MaPS ne peuvent pas être convertis directement en concepts Drupal.

Pour gérer ces attributs, nous utiliserons des entités custom de type **Contextualized attribute**.

Pour chaque attribut critérisé, il convient de créer un nouveau type de *Contextualized attribute*, possédant 2 champs :
- un champ contenant le critère : ce sera donc un champ *Entity Reference*
- un champ contenant la valeur : un champ de type texte, entier, booléen, ...

Un exemple de mapping d'attributs critérisés est donné à la fin de ce document.


### Commandes disponibles

Des commandes sont disponibles pour importer et effectuer un rollback (le rollback consiste simplement en la suppression
des données importées. Pour celà, on supprime toutes les entités en se basant sur l'entity type et le bundle défini dans
le convertisseur).

Ces commandes sont exécutables au niveau des profils et des convertisseurs.

PLusieurs modes d'import sont disponibles. Le mode par défaut va ajouter les opérations d'import des flux dans une file
d'attente interne, et un autre processus se charge ensuite de dépiler les éléments de cette file
d'attente et de générer les batchs nécessaires à l'import des données. Un mode plus "standard" (activé via l'option
`--no-batch-track`) utilise directement le système de batch de Drupal pour faire les imports.

---

#### Importer un profil

`drush a12s_maps_sync:import:profile <profile>`

**Alias** : `drush amsip <profile>`

**Options**

* `--limit=100` : définit le nombre d'éléments à importer
* `--force` : bypass le lock
* `--all` : force l'import de toutes les données
* `--batch-no-track` : utilise le système d'import standard
* `--do-not-process` : par défaut, après avoir ajouté les éléments à traiter dans la file d'attente, cette file est
traitée immédiatement. Cette option permet d'ajouter les éléments dans notre file d'attente et de ne pas les importer
immédiatement (mais via la commande `drush a12s_maps_sync:batch:process`)
* `--force-queue` : si on essaye d'importer un profil qui est déjà en cours d'import par notre batch, il n'est pas
ajouté à la queue. Cette option permet de l'ajouter tout de même dans la file d'attente.

*Remarque : l'option `--all` réinitialisera le timestamp de dernier import effectué*

----

#### Importer un convertisseur

`drush a12s_maps_sync:import:converter <converter>`

**Alias** : `drush amsic <converter>`

**Options**

Voir la commande [Importer un profil](#importer-un-profil)

----

#### Lancer l'auto-configuration d'un profil

`drush a12s_maps_sync:auto_config_profile <profile>`

**Alias** : `drush amsacp <profile>`

----

#### Lancer l'auto-configuration d'un convertisseur

`drush a12s_maps_sync:auto_config_converter <converter>`

**Alias** : `drush amsacc <converter>`

----

#### Importer une entité

`drush a12s_maps_sync:import_entity <entity_type> <entity_id>`

**Alias** : `amsie`

**Options**

* `--profile=<profile>` : Spécifie le profil à utiliser. Si vide, on essaye de le détecter automatiquement
* `--converter=<converter>` : Spécifie le convertisseur à utiliser. Si vide, on essaye de le détecter automatiquement
* `--with-dependencies` : Import également toutes les dépendances nécessaires

----

#### Importer un objet / media

`drush a12s_maps_sync:import_object <maps_type> <object_id> <converter>`

`<maps_type>` peut être `object` ou `media`.
`<object_id>` est l'identifiant de l'objet ou du média.

**Alias** : `amsio`

**Options**

* `--with-dependencies` : Import également toutes les dépendances nécessaires

----

#### Forcer le réimport complet d'un profil

Force un réimport complet en supprimant les timestamps des derniers imports effectués.

`druhs a12s_maps_sync:force_profile_reimport <profile>`

**Alias** : `drush amsfpr <profile>`

----

#### Forcer le réimport complet d'un convertisseur

Force un réimport complet en supprimant les timestamps du dernier import effectué.

`druhs a12s_maps_sync:force_converter_reimport <converter>`

**Alias** : `drush amsfcr <converter>`

----

#### Rollback un profil

**ATTENTION : CETTE COMMANDE SUPPRIME LES DONNÉES DRUPAL**

`drush a12s_maps_sync:rollback:profile <profile>`

**Alias** : `drush amsrp <profile>`

----

#### Rollback un convertisseur

**ATTENTION : CETTE COMMANDE SUPPRIME LES DONNÉES DRUPAL**

`drush a12s_maps_sync:rollback:converter <converter>`

**Alias** : `drush amsrc <converter>`

----

#### Libérer un lock

L'import créé un lock, qui est automatiquement libéré à la fin de l'import. Cependant, pour le libérer manuellement :

`drush a12s_maps_sync:release_lock <profile>`

Les locks sont, pour le moment, uniquement définis au niveau du profil.

**Alias** : `drush amsrl profile`

-----

#### Lister les locks

`drush a12s_maps_sync:list_locks`

**Alias** : `drush amsll`

------

#### Voir l'état du batch et la file d'attente

Cette commande de debug permet de savoir ce qui est stocké dans l'état du batch et de la file d'attente.

`drush a12s_maps_sync:batch:status`

**Alias** : `drush amsbs`

------

#### Exécuter le batch

Cette commande exécute :
- le batch en cours si il y en a un
- la prochaine opération en attente dans la file d'attente

Cette commande devrait idéalement être exécutée de manière régulière dans la crontab.

`drush a12s_maps_sync:batch:process`

**Alias** : `drush amsbp`

-------

#### Arrêter un batch

Cette commande permet d'arrêter les traitements en cours (en vidant les informations du batch actuel dans les tables
`batch` et `queue`).

`drush a12s_maps_sync:batch:kill`

**Alias** : `drush amsbk`

-------

#### Purger l'état actuel

Cette commande vide l'état actuel (batch en cours et file d'attente.

`drush a12s_maps_sync:batch:flush_state`

**Alias** : `drush amsbfs`


### Exemples de mappings complexes

#### Mapping d'un attribut objet

**Ce qu'on a dans MaPS :**
- des objets de type *Point of sale* (`POINT_OF_SALE`)
- des objets de type *Country* (`POS_COUNTRY`)
- un attribut objet *Country* (`COUNTRY`), qui référence les objets de type *POS Country* (`POS_COUNTRY`)

----

**Configuration Drupal :**
- Un type de node *Point of sale* (`pos`)
- Un vocabulaire *Country* (`pos_country`)
- Un champ *Country* (`field_pos_country`) au niveau des nodes *Point of sale* qui référence des termes de taxonomie *Country*

**Configuration a12s_maps_sync :**
- Un convertisseur *Country* (`pos_country`)
  - Handler : `Default`
  - Source - MaPS Type : `Object`
  - Target - Entity type : `Taxonomy term`
  - Target - Bundle : `Country`
  - Filtres :
    - Object type : `POS_COUNTRY`
  - Mappings :
    - `LABEL` :
      - Target : `name`
- Un convertisseur *Point of sale* (`point_of_sale`)
  - Handler : `Default`
  - Source - MaPS Type : `Object`
  - Target - Entity type : `Node`
  - Target - Bundle : `Point of sale`
  - Filtres :
    - Object type : `POINT_OF_SALE`
  - Mappings :
  - `LABEL` :
    - Target : `name`
  - `COUNTRY` :
    - Target : `field_pos_country`
    - Handler : `Entity Reference`
    - From converter : `pos_country`
    - Entity type : `default`


#### Mapping d'un attribut librairie

**Ce qu'on a dans MaPS :**
- des objets de type *Point of sale* (`POINT_OF_SALE`)
- une librairie *POS type* (`POS_TYPE`)
- un attribut librairie *Type* (`POS_TYPE_ATT`), qui référence la librairie *POS_TYPE* (`POS_TYPE`)

----

**Configuration Drupal :**
- Un type de node *Point of sale* (`pos`)
- Un vocabulaire *POS Type* (`pos_type`)
- Un champ *Type* (`field_pos_type`) au niveau des nodes *Point of sale* qui référence des termes de taxonomie *POS Type*

**Configuration a12s_maps_sync :**
- Un convertisseur *Type* (`pos_type`)
  - Handler : `Default`
  - Source - MaPS Type : `Library`
  - Target - Entity type : `Taxonomy term`
  - Target - Bundle : `POS Type`
  - Filtres :
    - Library name : `POS Type`
  - Mappings :
    - `Value` :
      - Target : `name`
- Un convertisseur *Point of sale* (`point_of_sale`)
  - Handler : `Default`
  - Source - MaPS Type : `Object`
  - Target - Entity type : `Node`
  - Target - Bundle : `Point of sale`
  - Filtres :
    - Type d'objet : `POINT_OF_SALE`
  - Mappings :
  - `LABEL` :
    - Target : `name`
  - `POS_TYPE_ATT` :
    - Target : `field_pos_type`
    - Handler : `Entity Reference`
    - From converter : `pos_type`
    - Entity type : `default`

## Annexes

### Intégration avec Monolog

Exemple d'intégration avec Monolog :
- les messages de debug sont enregistrés dans des fichiers sur 10 jours
- les erreurs sont envoyées sur Teams

```yaml
parameters:
  monolog.channel_handlers:
    a12s_maps_sync:
      handlers:
        - name: 'teams'
        - name: 'a12s_rotating_file'

services:
  monolog.handler.teams:
    class: \MonologMicrosoftTeams\TeamsLogHandler
    arguments: ['https://teams-webhook-url', 'ERROR']
  monolog.handler.a12s_rotating_file:
    class: Monolog\Handler\RotatingFileHandler
    arguments: ['private://logs/a12s_maps_sync.log', 10, 'DEBUG']

```
