(function ($, window, Drupal, once) {
  Drupal.behaviors.converterDrag = {
    attach: function attach(context, settings) {
      if (typeof Drupal.tableDrag === 'undefined' || typeof Drupal.tableDrag.converters === 'undefined') {
        return;
      }
      function checkEmptyregions(table, rowObject) {
        table.find('tr.region-message').each(function () {
          var $this = $(this);
          if ($this.prev('tr').get(0) === rowObject.element) {
            if (rowObject.method !== 'keyboard' || rowObject.direction === 'down') {
              rowObject.swap('after', this);
            }
          }
          if ($this.next('tr').is(':not(.draggable)') || $this.next('tr').length === 0) {
            $this.removeClass('region-populated').addClass('region-empty');
          } else if ($this.is('.region-empty')) {
            $this.removeClass('region-empty').addClass('region-populated');
          }
        });
      }
      function updateLastPlaced(table, rowObject) {
        table.find('.color-success').removeClass('color-success');
        var $rowObject = $(rowObject);
        if (!$rowObject.is('.drag-previous')) {
          table.find('.drag-previous').removeClass('drag-previous');
          $rowObject.addClass('drag-previous');
        }
      }
      function updateConverterWeights(table, region) {
        var weight = -Math.round(table.find('.draggable').length / 2);
        table.find(".region-".concat(region, "-message")).nextUntil('.region-title').find('select.converter-weight').each(function () {
          this.value = ++weight;
        });
      }
      var table = $('#converters');
      var tableDrag = Drupal.tableDrag.converters;
      tableDrag.row.prototype.onSwap = function (swappedRow) {
        checkEmptyregions(table, this);
        updateLastPlaced(table, this);
      };
      tableDrag.onDrop = function () {
        var dragObject = this;
        var $rowElement = $(dragObject.rowObject.element);
        var regionRow = $rowElement.prevAll('tr.region-message').get(0);
        var regionName = regionRow.className.replace(/([^ ]+[ ]+)*region-([^ ]+)-message([ ]+[^ ]+)*/, '$2');
        var regionField = $rowElement.find('select.converter-region-select');
        if (regionField.find("option[value=".concat(regionName, "]")).length === 0) {
          window.alert(Drupal.t('The converter cannot be placed in this region.'));
          regionField.trigger('change');
        }
        if (!regionField.is(".converter-region-".concat(regionName))) {
          var weightField = $rowElement.find('select.converter-weight');
          var oldregionName = weightField[0].className.replace(/([^ ]+[ ]+)*converter-weight-([^ ]+)([ ]+[^ ]+)*/, '$2');
          regionField.removeClass("converter-region-".concat(oldregionName)).addClass("converter-region-".concat(regionName));
          weightField.removeClass("converter-weight-".concat(oldregionName)).addClass("converter-weight-".concat(regionName));
          regionField[0].value = regionName;
        }
        updateConverterWeights(table, regionName);
      };
      $(once('converter-region-select', 'select.converter-region-select', context)).on('change', function (event) {
        var row = $(this).closest('tr');
        var select = $(this);
        tableDrag.rowObject = new tableDrag.row(row[0]);
        var regionMessage = table.find(".region-".concat(select[0].value, "-message"));
        var regionItems = regionMessage.nextUntil('.region-message, .region-title');
        if (regionItems.length) {
          regionItems.last().after(row);
        } else {
          regionMessage.after(row);
        }
        updateConverterWeights(table, select[0].value);
        checkEmptyregions(table, tableDrag.rowObject);
        updateLastPlaced(table, row);
        if (!tableDrag.changed) {
          $(Drupal.theme('tableDragChangedWarning')).insertBefore(tableDrag.table).hide().fadeIn('slow');
          tableDrag.changed = true;
        }
        select.trigger('blur');
      });
    }
  };
})(jQuery, window, Drupal, once);
