<?php

namespace Drupal\a12s_maps_sync\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Contextualized Attribute type configuration entity.
 *
 * @ConfigEntityType(
 *   id = "contextualized_attribute_type",
 *   label = @Translation("Contextualized Attribute type"),
 *   label_collection = @Translation("Contextualized Attribute types"),
 *   label_singular = @Translation("contextualized attribute type"),
 *   label_plural = @Translation("contextualized attributes types"),
 *   label_count = @PluralTranslation(
 *     singular = "@count contextualized attributes type",
 *     plural = "@count contextualized attributes types",
 *   ),
 *   handlers = {
 *     "form" = {
 *       "add" = "Drupal\a12s_maps_sync\Form\ContextualizedAttributeTypeForm",
 *       "edit" = "Drupal\a12s_maps_sync\Form\ContextualizedAttributeTypeForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *     "list_builder" = "Drupal\a12s_maps_sync\ContextualizedAttributeTypeListBuilder",
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     }
 *   },
 *   admin_permission = "administer contextualized attribute types",
 *   bundle_of = "contextualized_attribute",
 *   config_prefix = "contextualized_attribute_type",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "add-form" = "/admin/structure/contextualized_attribute_types/add",
 *     "edit-form" = "/admin/structure/contextualized_attribute_types/manage/{contextualized_attribute_type}",
 *     "delete-form" = "/admin/structure/contextualized_attribute_types/manage/{contextualized_attribute_type}/delete",
 *     "collection" = "/admin/structure/contextualized_attribute_types"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "uuid",
 *   }
 * )
 */
class ContextualizedAttributeType extends ConfigEntityBundleBase {

  /**
   * The machine name of this contextualized attribute type.
   *
   * @var string
   */
  protected string $id;

  /**
   * The human-readable name of the contextualized attribute type.
   *
   * @var string
   */
  protected string $label;

}
