<?php

namespace Drupal\a12s_maps_sync\Entity;

use Drupal\a12s_maps_sync\Converter\Mapping;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\a12s_maps_sync\Maps\BaseManagerInterface;
use Drupal\a12s_maps_sync\Plugin\MapsSyncHandlerInterface;
use Drupal\a12s_maps_sync\Plugin\SourceHandlerInterface;
use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides an interface for defining Maps sync converter entities.
 */
interface ConverterInterface extends ConfigEntityInterface {

  /** @var string  */
  public const STATUS_MANAGEMENT_UNPUBLISH = 'unpublish';

  /** @var string  */
  public const STATUS_MANAGEMENT_DELETE = 'delete';

  /** @var string  */
  public const STATUS_MANAGEMENT_UPDATE_EXISTING_IGNORE_STATUS = 'update_existing_ignore_status';

  /**
   * @return \Drupal\a12s_maps_sync\Entity\ProfileInterface
   */
  public function getProfile(): ?ProfileInterface;

  /**
   * @param string $profile_id
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setProfileId(string $profile_id): ConverterInterface;

  /**
   * @return string
   */
  public function getConverterEntityType(): ?string;

  /**
   * @param string $entity_type
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setConverterEntityType(string $entity_type): ConverterInterface;

  /**
   * @return string
   */
  public function getConverterBundle(): ?string;

  /**
   * @param string $bundle
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setConverterBundle(string $bundle): ConverterInterface;

  /**
   * @return array<\Drupal\a12s_maps_sync\Converter\Filter>|null
   */
  public function getFilters(): ?array;

  /**
   * @param array $filters
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setFilters(array $filters): ConverterInterface;

  /**
   * @return array<\Drupal\a12s_maps_sync\Converter\Mapping>|null
   */
  public function getMapping(): ?array;

  /**
   * @param array $mapping
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setMapping(array $mapping): ConverterInterface;

  /**
   * @return array
   */
  public function getPublishedStatuses(): array;

  /**
   * @param array $statuses
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setPublishedStatuses(array $statuses): ConverterInterface;


  /**
   * @return array
   */
  public function getUnpublishedStatuses(): array;

  /**
   * @param array $statuses
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setUnpublishedStatuses(array $statuses): ConverterInterface;


  /**
   * @return array
   */
  public function getDeletedStatuses(): array;

  /**
   * @param array $statuses
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setDeletedStatuses(array $statuses): ConverterInterface;

  /**
   * @return string
   */
  public function getStatusManagement(): ?string;

  /**
   * @param string $statusManagement
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setStatusManagement(string $statusManagement): ConverterInterface;

  /**
   * @return string
   */
  public function getStatusProperty(): ?string;

  /**
   * @param string $mediaStatusProperty
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setStatusProperty(string $mediaStatusProperty): ConverterInterface;

  /**
   * Retrieves the status property name.
   *
   * @return string|null The status property name, or null if it is not set.
   */
  public function getStatusPropertyName(): ?string;

  /**
   * Set the status property name.
   *
   * @param string $statusPropertyName The name of the status property.
   *
   * @return ConverterInterface The ConverterInterface instance.
   */
  public function setStatusPropertyName(string $statusPropertyName): ConverterInterface;

  /**
   * @return string|null
   */
  public function getMediaStatusPublishedValue(): ?string;

  /**
   * @return bool
   */
  public function getFlushImageStyles(): bool;

  /**
   * @param string $publishedValue
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setMediaStatusPublishedValue(string $publishedValue): ConverterInterface;

  /**
   * @return array
   */
  public function getGid(): array;

  /**
   * @param array $gid
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setGid(array $gid): ConverterInterface;

  /**
   * @return string
   */
  public function getMapsType(): ?string;

  /**
   * @param string $type
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setMapsType(string $type): ConverterInterface;

  /**
   * @return string
   */
  public function getParent(): ?string;

  /**
   * @param string $parent
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setParent(string $parent): ConverterInterface;

  /**
   * @return int
   */
  public function getWeight(): ?int;

  /**
   * @param int $weight
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setWeight(int $weight): ConverterInterface;

  /**
   * @return \Drupal\a12s_maps_sync\Maps\MapsSyncHandlerInterface
   */
  public function getHandler(): MapsSyncHandlerInterface;

  /**
   * @return string
   */
  public function getHandlerId(): ?string;

  /**
   * @param string $handler_id
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface
   */
  public function setHandlerId(string $handler_id): ConverterInterface;

  /**
   * @return \Drupal\a12s_maps_sync\Plugin\SourceHandlerInterface
   */
  public function getSourceHandler(): SourceHandlerInterface;

  /**
   * Process the converter import.
   *
   * @return mixed
   */
  public function import(int $limit): array;

  /**
   * Process a rollback by deleting all entities matching the current converter.
   * We based our query on the entity type and bundle defined in the converter.
   *
   * @return mixed
   */
  public function rollback();

  /**
   * Get the lock name.
   *
   * @return string
   */
  public function getLockName(): string;

  /**
   * @return int
   */
  public function getLastImportedTime(): int;

  /**
   * @param int $time
   *
   * @return void
   */
  public function setLastImportedTime(int $time): void;

  /**
   * @return void
   */
  public function resetLastImportedTime(): void;

  /**
   * @return array|null
   */
  public function getAutoConfig(): ?array;

  /**
   * @param array|null $auto_config
   *
   * @return Converter
   */
  public function setAutoConfig(?array $auto_config): Converter;

  /**
   * @param \Drupal\a12s_maps_sync\Converter\Mapping $mapping
   *
   * @return \Drupal\a12s_maps_sync\Entity\Converter
   */
  public function addMappingItem(Mapping $mapping): Converter;

  /**
   * Get the converter dependencies.
   *
   * @return \Drupal\a12s_maps_sync\Entity\ConverterInterface[]
   */
  public function getConverterDependencies(array &$dependencies = []): array;

  /**
   * Import a given entity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *
   * @return void
   */
  public function importEntity(EntityInterface $entity);

  /**
   * Import a given object.
   *
   * @param \Drupal\a12s_maps_sync\Maps\BaseInterface $object
   *
   * @return array|mixed|null
   */
  public function importObject(BaseInterface $object);

  /**
   * @param \Drupal\a12s_maps_sync\Maps\BaseInterface $object
   *
   * @return bool
   */
  public function objectMatchFilters(BaseInterface $object): bool;

}
