<?php

namespace Drupal\a12s_maps_sync\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining MaPS Sync profile entities.
 */
interface ProfileInterface extends ConfigEntityInterface {

  /**
   * Get all converters of the profile.
   *
   * @return array<\Drupal\a12s_maps_sync\Entity\ConverterInterface>
   */
  public function getConverters(): array;

  /**
   * Get the default MaPS language id.
   *
   * @return int|null
   */
  public function getDefaultMapslanguage(): ?int;

  /**
   * Set the default MaPS language id.
   *
   * @param int $language
   *
   * @return \Drupal\a12s_maps_sync\Entity\ProfileInterface
   */
  public function setDefaultMapslanguage(int $language): ProfileInterface;

  /**
   * Get the medias path.
   *
   * @return string|null
   */
  public function getMediasPath(): ?string;

  /**
   * Set the medias path.
   *
   * @param string $medias_path
   *
   * @return \Drupal\a12s_maps_sync\Entity\ProfileInterface
   */
  public function setMediasPath(string $medias_path): ProfileInterface;

  /**
   * Get the lock name.
   */
  public function getLockName(): string;

  /**
   * Gets the available parents.
   *
   * @return array
   */
  public function getAvailableParents(): array;

  /**
   * Retrieves the Python profile ID.
   *
   * @return string The Python profile ID.
   */
  public function getPythonProfileId(): string;

  /**
   * Sets the Python profile ID.
   *
   * @param string $python_profile_id The Python profile ID to set.
   *
   * @return \Drupal\a12s_maps_sync\Entity\ProfileInterface The updated profile object.
   */
  public function setPythonProfileId(string $python_profile_id): ProfileInterface;

}
