<?php

declare(strict_types=1);

namespace Drupal\a12s_maps_sync\Form;

use Drupal\a12s_maps_sync\MapsApiTrait;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Messenger\MessengerTrait;

/**
 * Ensure MaPS API is available for dependant forms.
 */
trait ApiDependantFormTrait {

  use MapsApiTrait;
  use MessengerTrait;

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    if (!$this->mapsApi()->isAvailable()) {
      $this->messenger()->addError($this->t('The MaPS API is not available.'));
      return $form;
    }

    return parent::buildForm($form, $form_state);
  }

}
