<?php

namespace Drupal\a12s_maps_sync\Maps\Exception;

/**
 * Maps Sync exception class to be thrown when an entity definition is missing
 * some required parameters.
 */
class MapsEntityDefinitionException extends \Exception {

  /**
   * {@inheritDoc}
   *
   * For the remaining parameters see \Exception.
   *
   * @param string $entity_type
   *   The related entity type.
   * @param string $parameter
   *   The parameter that was not found.
   *
   * @see \Exception
   */
  public function __construct(string $entity_type, string $parameter, $message = '', $code = 0, \Exception $previous = NULL) {
    if (empty($message)) {
      $message = sprintf(
        "Missing parameter '%s' in the '%s' entity type definition.",
        $parameter,
        $entity_type
      );
    }
    parent::__construct($message, $code, $previous);
  }

}
