<?php

namespace Drupal\a12s_maps_sync\Maps;

class Link extends Base implements LinkInterface {

  /**
   * @param int $source_id
   * @param int $target_id
   * @param int $type_id
   * @param int $count
   */
  public function __construct(
    protected int $source_id,
    protected int $target_id,
    protected int $type_id,
    protected int $count,
  ){
    parent::__construct();
  }

  /**
   * {@inheritdoc}
   */
  public function getSourceId(): int {
    return $this->source_id;
  }

  /**
   * {@inheritdoc}
   */
  public function setSourceId(int $source_id): Link {
    $this->source_id = $source_id;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getTargetId(): int {
    return $this->target_id;
  }

  /**
   * {@inheritdoc}
   */
  public function setTargetId(int $target_id): Link {
    $this->target_id = $target_id;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getTypeId(): int {
    return $this->type_id;
  }

  /**
   * {@inheritdoc}
   */
  public function setTypeId(int $type_id): Link {
    $this->type_id = $type_id;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getCount(): int {
    return $this->count;
  }

  /**
   * {@inheritdoc}
   */
  public function setCount(int $count): Link {
    $this->count = $count;
    return $this;
  }

}
