<?php

namespace Drupal\a12s_maps_sync\Maps;

use Drupal\a12s_maps_sync\Entity\Profile;
use Drupal\Core\Entity\Query\QueryInterface;

class Media extends Base implements MediaInterface {

  /**
   * The media extension.
   *
   * @var string
   */
  protected string $extension;

  /**
   * The MaPS type id.
   *
   * @var int
   */
  protected int $type;

  /**
   * The MaPS Url for the media.
   *
   * @var string
   */
  protected string $url;

  /**
   * The media weight.
   *
   * @var int
   */
  protected int $weight;

  /**
   * The file name.
   *
   * @var string
   */
  protected string $filename;

  public function __construct(
    int $id,
    string $extension,
    string $url,
    string $filename,
    string $type,
    int $weight,
    int $imported,
  ) {
    parent::__construct();
    $this->id = $id;
    $this->extension = $extension;
    $this->url = $url;
    $this->filename = $filename;
    $this->type = $type;
    $this->weight = $weight;
    $this->imported = $imported;
  }

  /**
   * {@inheritdoc}
   */
  public function getExtension(): string {
    return $this->extension;
  }

  /**
   * {@inheritdoc}
   */
  public function setExtension(string $extension): Media {
    $this->extension = $extension;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getType(): int {
    return $this->type;
  }

  /**
   * {@inheritdoc}
   */
  public function setType(int $type): Media {
    $this->type = $type;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getUrl(): string {
    return $this->url;
  }

  /**
   * {@inheritdoc}
   */
  public function setUrl(string $url): Media {
    $this->url = $url;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getWeight(): int {
    return $this->weight;
  }

  /**
   * {@inheritdoc}
   */
  public function setWeight(int $weight): Media {
    $this->weight = $weight;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getFilename(): string {
    return $this->filename;
  }

  /**
   * {@inheritdoc}
   */
  public function setFilename(string $filename): Media {
    $this->filename = $filename;
    return $this;
  }

  /**
   * {@inheritDoc}
   */
  public function getCountValues(string $name): int {
    $properties = ['id', 'profile', 'converter', 'type', 'extension', 'url', 'weight', 'filename'];
    if (in_array($name, $properties)) {
      return 1;
    }

    return parent::getCountValues($name);
  }

  /**
   * {@inheritdoc}
   */
  public function get(string $name, int $language_id = NULL, $delta = NULL) {
    $properties = ['id', 'profile', 'converter', 'type', 'extension', 'url', 'weight', 'filename'];

    if (in_array($name, $properties, TRUE)) {
      return $this->{$name};
    }

    if ($language_id === NULL) {
      $profile = Profile::load($this->getProfile());
      $language_id = $profile->getDefaultMapslanguage();
    }

    return parent::get($name, $language_id, $delta);
  }

}
