<?php

declare(strict_types=1);

namespace Drupal\a12s_maps_sync;

/**
 * Provides a trait for the MaPS API service.
 */
trait MapsApiTrait {

  /**
   * The MaPS API service.
   *
   * @var \Drupal\a12s_maps_sync\MapsApi
   */
  protected MapsApi $mapsApi;

  /**
   * Get the MaPS API service.
   *
   * @return \Drupal\a12s_maps_sync\MapsApi
   */
  protected function mapsApi(): MapsApi {
    if (!isset($this->mapsApi)) {
      $this->mapsApi = \Drupal::service('a12s_maps_sync.maps_api');
    }

    return $this->mapsApi;
  }

}
