<?php

namespace Drupal\a12s_maps_sync\Plugin\MappingHandler;

use Drupal\a12s_maps_sync\Converter\Mapping;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Language\LanguageInterface;

/**
 * Plugin implementation of the a12s_maps_sync_mapping_handler.
 *
 * @MappingHandler(
 *   id = "html",
 *   label = @Translation("HTML"),
 *   description = @Translation("HTML.")
 * )
 */
class HtmlHandler extends DefaultHandler {

  /**
   * {@inheritdoc}
   */
  public function getAdditionalFieldParameters(): array {
    return ['format' => 'html_full'];
  }

}
