<?php

namespace Drupal\a12s_maps_sync\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Provides the MaPS Sync handler plugin manager.
 */
class MapsSyncHandlerManager extends DefaultPluginManager {


  /**
   * Constructs a new MapsSyncHandlerManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/MapsSyncHandler', $namespaces, $module_handler, 'Drupal\a12s_maps_sync\Plugin\MapsSyncHandlerInterface', 'Drupal\a12s_maps_sync\Annotation\MapsSyncHandler');

    $this->alterInfo('a12s_maps_sync_maps_sync_handler_info');
    $this->setCacheBackend($cache_backend, 'a12s_maps_sync_maps_sync_handler_plugins');
  }

}
