<?php

namespace Drupal\a12s_maps_sync\Event;

use Drupal\a12s_maps_sync\Entity\ConverterInterface;
use Drupal\a12s_maps_sync\Maps\BaseInterface;
use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Language\LanguageInterface;

class ConverterItemImportEvent extends Event {

  const string FINISHED = 'a12s_maps_sync_converter_item_import_finished';

  /** @var ConverterInterface */
  public ConverterInterface $converter;

  /** @var BaseInterface */
  public BaseInterface $object;

  /** @var EntityInterface */
  public EntityInterface $entity;

  /** @var LanguageInterface */
  public LanguageInterface $language;

  /**
   * @param ConverterInterface $converter
   * @param BaseInterface $object
   * @param EntityInterface $entity
   * @param LanguageInterface|null $language
   */
  public function __construct(ConverterInterface $converter, BaseInterface $object, EntityInterface $entity, ?LanguageInterface $language = NULL) {
    $this->converter = $converter;
    $this->object = $object;
    $this->entity = $entity;
    $this->language = $language;
  }

}
