<?php

namespace Drupal\a12s_maps_sync\Maps;

/**
 * Interface AttributeInterface
 */
interface AttributeInterface {

  /**
   * @return string
   */
  public function getCode(): string;

  /**
   * @param string $code
   *
   * @return Attribute
   */
  public function setCode(string $code): Attribute;

  /**
   * Get an attribute value or extra data.
   *
   * @param int $language_id
   * @param int $delta
   *
   * @return mixed
   */
  public function getValue(int $language_id, int $delta = 0);

  /**
   * Get the count of values for the attribute.
   *
   * @return int
   */
  public function getCountValue(): int;

}
