<?php

namespace Drupal\a12s_maps_sync\Routing;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Symfony\Component\Routing\Route;

/**
 * Provides routes for MaPS Sync profile entities.
 *
 * @see Drupal\Core\Entity\Routing\AdminHtmlRouteProvider
 * @see Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider
 */
class ProfileHtmlRouteProvider extends AdminHtmlRouteProvider {

  /**
   * {@inheritdoc}
   */
  public function getRoutes(EntityTypeInterface $entity_type) {
    $collection = parent::getRoutes($entity_type);

    if ($converters_form_route = $this->getConvertersFormRoute($entity_type)) {
      $collection->add("entity.maps_sync_profile.converters_form", $converters_form_route);
    }

    if ($import_form_route = $this->getImportFormRoute($entity_type)) {
      $collection->add("entity.maps_sync_profile.import_form", $import_form_route);
    }

    if ($attribute_import_wizard_form_route = $this->getAttributeImportWizardFormRoute($entity_type)) {
      $collection->add("entity.maps_sync_profile.attribute_import_wizard_form", $attribute_import_wizard_form_route);
    }

    return $collection;
  }

  /**
   * Gets the import-form route.
   *
   * @param \Drupal\Core\Entity\EntityTypeInterface $entity_type
   *   The entity type.
   *
   * @return \Symfony\Component\Routing\Route|null
   *   The generated route, if available.
   */
  protected function getAttributeImportWizardFormRoute(EntityTypeInterface $entity_type) {
    if ($entity_type->hasLinkTemplate('attribute-import-wizard-form')) {
      $route = new Route($entity_type->getLinkTemplate('attribute-import-wizard-form'));
      $route
        ->setDefaults([
          '_entity_form' => "maps_sync_profile.attribute_import_wizard",
          '_title' => 'Attribute import wizard',
        ])
        ->setRequirement('_permission', "maps_sync_profile.update")
        ->setOption('parameters', [
          'maps_sync_profile' => ['type' => 'entity:maps_sync_profile'],
        ]);

      if ($this->getEntityTypeIdKeyType($entity_type) === 'integer') {
        $route->setRequirement('maps_sync_profile', '\d+');
      }

      return $route;
    }
  }

  /**
   * Gets the import-form route.
   *
   * @param \Drupal\Core\Entity\EntityTypeInterface $entity_type
   *   The entity type.
   *
   * @return \Symfony\Component\Routing\Route|null
   *   The generated route, if available.
   */
  protected function getImportFormRoute(EntityTypeInterface $entity_type) {
    if ($entity_type->hasLinkTemplate('import-form')) {
      $route = new Route($entity_type->getLinkTemplate('import-form'));
      $route
        ->setDefaults([
          '_entity_form' => "maps_sync_profile.import",
          '_title_callback' => 'Drupal\a12s_maps_sync\Form\ProfileImportForm::title',
        ])
        ->setRequirement('_permission', "import a12s maps sync profile")
        ->setOption('parameters', [
          'maps_sync_profile' => ['type' => 'entity:maps_sync_profile'],
        ]);

      if ($this->getEntityTypeIdKeyType($entity_type) === 'integer') {
        $route->setRequirement('maps_sync_profile', '\d+');
      }

      return $route;
    }
  }

  /**
   * @param \Drupal\Core\Entity\EntityTypeInterface $entity_type
   */
  protected function getConvertersFormRoute(EntityTypeInterface $entity_type) {
    if ($entity_type->hasLinkTemplate('converters-form')) {
      $route = new Route($entity_type->getLinkTemplate('converters-form'));

      $route
        ->setDefaults([
          '_form' => "\Drupal\a12s_maps_sync\Form\ProfileConvertersForm",
          '_title' => 'Converters',
        ])
        ->setRequirement('_entity_access', 'maps_sync_profile.update')
        ->setOption('parameters', [
          'maps_sync_profile' => ['type' => 'entity:maps_sync_profile'],
        ]);

      if ($this->getEntityTypeIdKeyType($entity_type) === 'integer') {
        $route->setRequirement('maps_sync_profile', '\d+');
      }

      return $route;
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function getCanonicalRoute(EntityTypeInterface $entity_type) {
    return $this->getEditFormRoute($entity_type);
  }

}
