<?php

/**
 * @file
 * Token integration for Access Code module.
 */

use Drupal\Core\Render\BubbleableMetadata;

/**
 * Implements hook_token_info().
 */
function access_code_token_info() {
  $info = [];

  $info['tokens']['user']['access-code'] = [
    'name' => t('Access code'),
    'description' => t('The access code assigned to the user.'),
  ];

  $info['tokens']['user']['access-code-expiration'] = [
    'name' => t('Access code expiration'),
    'description' => t('The expiration date of the user\'s access code.'),
  ];

  return $info;
}

/**
 * Implements hook_tokens().
 */
function access_code_tokens($type, $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata) {
  $replacements = [];

  /* @var \Drupal\access_code\Service\AccessCodeManager $manager */
  $manager = \Drupal::service('access_code.manager');

  if ($type == 'user' && !empty($data['user'])) {
    /** @var \Drupal\user\UserInterface $account */
    $account = $data['user'];
    $access_code = $manager->getAccessCode($account->id());

    foreach ($tokens as $name => $original) {
      switch ($name) {
        case 'access-code':
          $replacements[$original] = $access_code['code'] ?? NULL;
          break;

        case 'access-code-expiration':
          $replacements[$original] = $access_code['expiration'] ?? NULL;
          break;
      }
    }
  }

  return $replacements;
}
