# ACCESS Job Reporting

Reports TAPIS job metadata to the ACCESS-CI Allocations API so science gateway usage of ACCESS resources is tracked via standardized job reporting.

Link: https://allocations-api.access-ci.org/acdb/


## Features
- Enqueues and reports TAPIS job attributes to ACCESS `job_attributes` endpoint.
- Per-TAPIS System mapping from TAPIS queues to ACCESS resource names.
- Optional integration with the Key module to store/retrieve the ACCESS API key securely.
- Built-in helper to fetch and display suggested ACCESS resource names.
- Debug mode for dry-run logging without sending HTTP requests.


## Requirements
- Drupal core: 10.4.x
- php: >=8.1
- Modules:
  - `tapis_job` (https://www.drupal.org/project/tapis_job)
  - `tapis_system` (https://www.drupal.org/project/tapis_system)
  - Optional: `key` to manage the ACCESS API key securely

## Configuration
- Path: `Administration` → `Configuration` → `Web services` → `ACCESS Job Reporting`
  - Route: `/admin/config/access/job-reporting`

Settings
- `Endpoint URL (job_attributes)`: Defaults to the ACCESS production endpoint. Override for testing.
- `ACCESS API key`:
  - With Key module: select an existing Key; the secret is never stored in this module’s config.
  - Without Key module: enter the API key directly (stored in config).
- `Agent name (XA-AGENT)`: Optional header value for ACCESS.
- `Enable debug mode (no POSTs)`: When enabled, the worker logs payloads instead of sending HTTP POSTs.
- `Retry interval (seconds)`: Default 86400 (1 day).
- `Max attempts`: Default 15.

Suggested resources helper
- Click “Reload ACCESS Resources” to retrieve suggested ACCESS resource names. This performs a POST to the endpoint with a synthetic value to prompt the suggestions list, then displays the names.


## Per-System Mapping (Queues → ACCESS Resources)
This mapping is configured per `tapis_system` node.

- Edit a `tapis_system` node and open the “ACCESS Job Reporting” fieldset.
- Check “Report to ACCESS”.
- Fill “ACCESS Resource Map” with one mapping per line using the format:

  resource.example.org | queue1, queue2, queue3

Example
- Expanse system node:
  - `expanse.sdsc.xsede.org | normal, gpu`
- Bridges-2 system node:
  - `bridges2.psc.xsede.org | cpu, long`

## How It Works
- When a TAPIS job is created, the module inspects the job metadata:
  - Loads the corresponding `tapis_system` node’s resource map.
  - Reads the job’s `execSystemLogicalQueue` and resolves the ACCESS resource via the map.
  - Extracts additional fields such as user, submit time, software name/version, and remote job id (if present).
  - Enqueues a report item to the Drupal queue `access_job_reporting.job_queue`.
- The queue worker (runs on cron) posts the report to ACCESS.
  - If `remoteJobId` or `submittime` is missing, the worker attempts a lightweight fetch from TAPIS and requeues when needed.
  - On HTTP failure, it retries up to “Max attempts”, spacing retries by “Retry interval”.
  - In debug mode, it logs the payload and does not POST.
