<?php

/**
 * @file
 * Documentation for the access_unpublished module API.
 */

/**
 * Alter the duration options array.
 *
 * @param array $options
 *   An associative array of duration options.
 */
function hook_access_unpublished_duration_options_alter(array &$options) {
  // Remove the unlimited duration option.
  unset($options[-1]);
  // Add a "4 weeks" duration option.
  $date_formatter = \Drupal::service('date.formatter');
  $options[2419200] = $date_formatter->formatInterval(2419200);
}
