<?php

namespace Drupal\access_unpublished;

use Drupal\views\EntityViewsData;

/**
 * Provides the views data for the access_token entity type.
 */
class AccessTokenViewsData extends EntityViewsData {

  /**
   * {@inheritdoc}
   */
  public function getViewsData() {
    $data = parent::getViewsData();

    $applicable_entity_types = [];
    foreach ($this->entityTypeManager->getDefinitions() as $entity_type) {
      if (AccessUnpublished::applicableEntityType($entity_type)) {
        $applicable_entity_types[$entity_type->id()] = $entity_type;
      }
    }

    foreach ($applicable_entity_types as $entity_type_id => $type) {
      // Decide what column to use as base field depending on this entity type
      // "id" type.
      $id_key = $type->getKey('id');
      /** @var \Drupal\Core\Field\BaseFieldDefinition $id_field */
      $id_field = $this->entityFieldManager->getBaseFieldDefinitions($entity_type_id)[$id_key];

      // Prefer the data table which most views are based on.
      $source_table_name = $type->getDataTable() ?: $type->getBaseTable();
      if ($source_table_name) {
        $data['access_token']['entity_id_' . $type->id()] = [
          'title' => t('@entity_type entity type related from entity_id', [
            '@entity_type' => $type->getLabel(),
          ]),
          'help' => t('Creates a relationship about the entity_id field and <em>@entity_type</em> contents.', [
            '@entity_type' => $type->getLabel(),
          ]),
          'relationship' => [
            'base' => $source_table_name,
            'base field' => $id_key,
            'field' => 'entity_id',
            'id' => 'standard',
            'label' => t('Contents (@entity_type)', [
              '@entity_type' => $type->getLabel(),
            ]),
          ],
        ];
      }
    }

    // Issue #3394195 - Handler overwritten for add the js library.
    $data['access_token']['operations']['field']['id'] = 'access_unpublished_view_entity_operations';

    // Issue #3394195 - Copy raw url field.
    $data['access_token']['access_unpublished_copy_raw_url'] = [
      'title' => t('Copy raw url'),
      'help' => t('Provides the access token link as a text.'),
      'field' => ['id' => 'access_unpublished_copy_raw_url'],
    ];

    return $data;
  }

}
