<?php

namespace Drupal\access_unpublished\Plugin\views\field;

use Drupal\views\Plugin\views\field\EntityOperations;
use Drupal\views\ResultRow;

/**
 * Field handler to Access Unpublished Copy Value.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("access_unpublished_copy_raw_url")
 */
class AccessUnpublishedCopyRawUrl extends EntityOperations {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $build = parent::render($values);
    if (isset($build['#links']['copy']['attributes']['data-unpublished-access-url'])) {
      return $build['#links']['copy']['attributes']['data-unpublished-access-url'];
    }

    return '';
  }

  /**
   * {@inheritdoc}
   */
  public function query() {}

}
