<?php

namespace Drupal\access_unpublished\Plugin\views\field;

use Drupal\views\Plugin\views\field\EntityOperations;
use Drupal\views\ResultRow;

/**
 * Field handler to Access Unpublished Entity View Operations.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("access_unpublished_view_entity_operations")
 */
class AccessUnpublishedViewEntityOperations extends EntityOperations {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $build = parent::render($values);
    $build['#attached'] = [
      'library' => ['access_unpublished/drupal.access_unpublished.admin'],
    ];
    return $build;
  }

  /**
   * {@inheritdoc}
   */
  public function query() {}

}
