<?php

namespace Drupal\Tests\access_unpublished\Functional;

use Drupal\node\Entity\NodeType;
use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\node\Traits\NodeCreationTrait;
use Drupal\user\RoleInterface;

/**
 * Tests the AccessUnpublishedForm.
 *
 * @group access_unpublished
 */
class AccessUnpublishedFormTest extends BrowserTestBase {

  use NodeCreationTrait;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'access_unpublished',
    'node',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    NodeType::create(['type' => 'page', 'name' => 'page'])->save();

    user_role_grant_permissions(RoleInterface::ANONYMOUS_ID, [
      'access content',
    ]);

    $this->drupalLogin($this->drupalCreateUser([
      'edit any page content',
      'access_unpublished node page',
    ]));
  }

  /**
   * Tests that a token can be created with a label.
   */
  public function testTokenCreationWithLabel() {
    $assert_session = $this->assertSession();

    // Create an unpublished node.
    $node = $this->createNode(['status' => FALSE]);

    $this->drupalGet($node->toUrl('edit-form'));
    $assert_session->statusCodeEquals(200);

    // Create a token with a label.
    $edit = [
      'token_label' => 'My test token',
    ];
    $this->submitForm($edit, 'Generate token');

    // The page is reloaded with the new token.
    $assert_session->fieldValueEquals('token_label', 'My test token');
  }

}
