<?php

namespace Drupal\Tests\access_unpublished\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the SettingsForm.
 *
 * @group access_unpublished
 */
class SettingsFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['access_unpublished', 'node'];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->drupalLogin($this->drupalCreateUser(['administer site configuration']));
  }

  /**
   * Test callback for validateHttpHeaders.
   */
  public function testValidateHttpHeaders() {
    $assert_session = $this->assertSession();

    $this->drupalGet('admin/config/content/access_unpublished');
    $assert_session->statusCodeEquals(200);

    // Test empty headers.
    $edit = [
      'modify_http_headers' => '',
    ];
    $this->submitForm($edit, 'Save configuration');
    $assert_session->pageTextContains('The configuration options have been saved.');

    // Test valid headers.
    $edit = [
      'modify_http_headers' => "X-Robots-Tag|noindex\nX-Custom-Header|some_value",
    ];
    $this->submitForm($edit, 'Save configuration');
    $assert_session->pageTextContains('The configuration options have been saved.');

    // Test invalid headers.
    $edit = [
      'modify_http_headers' => "X-Robots-Tag noindex",
    ];
    $this->submitForm($edit, 'Save configuration');
    $assert_session->pageTextContains('Missing pipe separator (|). Format should be "Header-Name|value".');

    $edit = [
      'modify_http_headers' => "|noindex",
    ];
    $this->submitForm($edit, 'Save configuration');
    $assert_session->pageTextContains('Header name cannot be empty.');

    $edit = [
      'modify_http_headers' => "X-Robots-Tag@|noindex",
    ];
    $this->submitForm($edit, 'Save configuration');
    $assert_session->pageTextContains('Invalid header name "X-Robots-Tag@". Header names can only contain letters, numbers, and certain special characters.');

    $edit = [
      'modify_http_headers' => "X-Robots-Tag|noindex" . chr(7),
    ];
    $this->submitForm($edit, 'Save configuration');
    $assert_session->pageTextContains('Header value contains invalid control characters.');
  }

}
