<?php

namespace Drupal\Tests\access_unpublished\Kernel;

use Drupal\access_unpublished\Form\AccessUnpublishedForm;
use Drupal\KernelTests\KernelTestBase;

/**
 * Test the access_unpublished_duration_options_alter hook.
 *
 * @group access_unpublished
 */
class DurationOptionsAlterHookTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'access_unpublished',
    'access_unpublished_test',
  ];

  /**
   * Tests that the hook is properly invoked.
   */
  public function testHook() {
    $options = AccessUnpublishedForm::getDurationOptions();
    $this->assertArrayNotHasKey(-1, $options);
    $this->assertArrayHasKey(2419200, $options);
  }

}
