<?php

namespace Drupal\Tests\access_unpublished\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\HttpKernelInterface;

/**
 * @covers \Drupal\access_unpublished\TokenGetter::setTokenFromRequest
 * @group access_unpublished
 */
class TokenGetterTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'access_unpublished',
  ];

  /**
   * The token getter service.
   *
   * @var \Drupal\access_unpublished\TokenGetter
   */
  protected $tokenGetter;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->config('access_unpublished.settings')->set('hash_key', 'auHash')->save();
    $this->tokenGetter = $this->container->get('access_unpublished.token_getter');
  }

  /**
   * Tests that the token is properly set from the request.
   */
  public function testSetTokenFromRequest() {
    // Test with a valid token.
    $request = Request::create('/node/1', 'GET', ['auHash' => 'valid-token']);
    $event = new RequestEvent($this->container->get('http_kernel'), $request, HttpKernelInterface::MAIN_REQUEST);
    $this->tokenGetter->setTokenFromRequest($event);
    $this->assertEquals('valid-token', $this->tokenGetter->getToken());

    // Test with an invalid UTF-8 token.
    $request = Request::create('/node/1', 'GET', ['auHash' => "\xC3\x28"]);
    $event = new RequestEvent($this->container->get('http_kernel'), $request, HttpKernelInterface::MAIN_REQUEST);
    $this->tokenGetter->setTokenFromRequest($event);
    $this->assertEquals('', $this->tokenGetter->getToken());
  }

}
