# Accessibility Filters

Provides text filters that remove empty elements (headings, links) for
accessibility compliance.

## Overview

Empty semantic elements are problematic for accessibility as they create
confusion for screen readers and assistive technologies:

- **Empty heading tags** (h1–h6) create semantic confusion and often occur
  when content editors create a new line from the beginning of a heading.
- **Empty anchor tags** serve no purpose and break keyboard navigation and
  screen reader flows.

This module provides two independent filters to address these issues:

1. **Empty Headings Filter**: Converts empty h1–h6 elements to paragraph
   tags, maintaining visual spacing while fixing accessibility issues.
2. **Empty Links Filter**: Completely removes empty anchor (`<a>`) tags
   since they are inline elements that serve no purpose when empty.

## Installation

1. Enable the module: `drush en accessibility_filters`
2. Go to **Configuration > Content authoring > Text formats and
   editors**
3. Edit your desired text format (e.g., "Full HTML")
4. Enable one or both filter checkboxes:
   - "Empty headings filter"
   - "Empty links filter"
5. Configure the filter weights as needed (default: 10)
6. Save configuration

## Filters

### Empty Headings Filter

- **Plugin ID**: `empty_headings_filter`
- **What it does**: Replaces empty h1–h6 elements with `<p>` tags,
  preserving all attributes and child elements.
- **Why**: Maintains block-level layout spacing while removing semantic
  accessibility issues.

### Empty Links Filter

- **Plugin ID**: `empty_links_filter`
- **What it does**: Completely removes empty `<a>` elements from the DOM.
- **Why**: Empty links are inline elements that serve no purpose and
  interfere with keyboard navigation and screen readers.

## Testing

This module includes PHPUnit unit test coverage:

- **Unit tests** for both filter plugins (covering whitespace, `&nbsp;`,
  comments, empty inline wrappers, attributes, children, and `<br>`).

Run all tests for this module from the Drupal web root:

```bash
../vendor/bin/phpunit -c core/phpunit.xml.dist \
  modules/contrib/accessibility_filters/tests
```

## License

GPL-2.0+
