## CONTENTS OF THIS FILE

 * Introduction
 * Requirements
 * Recommended Modules
 * Installation
 * Configuration
 * Maintainers


## INTRODUCTION

The Sign for acknowledgement module is useful if you have to check which users
have read your Drupal documents. When these documents are displayed, a checkbox
appears and the current user should be able to sign for acknowledgement by
selecting it.

 * For a full description of the module visit:
   https://www.drupal.org/project/acknowledgements

 * To submit bug reports and feature suggestions, or to track changes visit:
   https://www.drupal.org/project/issues/acknowledgements


## REQUIREMENTS

This module requires:

 * Drupal 10.0 or higher, OR Drupal 11.0 or higher
 * PHP 8.1 or higher
 * Token module - https://www.drupal.org/project/token

### Compatibility Matrix

| Drupal Version | PHP Version | Module Version | Status       |
|---------------|-------------|----------------|--------------|
| 10.x          | 8.1+        | 3.0.0+         | ✓ Supported  |
| 11.x          | 8.3+        | 3.0.0+         | ✓ Supported  |
| 9.x           | 8.0+        | 2.0.0          | End of Life  |


## RECOMMENDED MODULES

 * Multiple Selects - https://www.drupal.org/project/multiple_selects


## INSTALLATION

Install the Sign for acknowledgement module as you would normally install a
contributed Drupal module. Visit https://www.drupal.org/node/1897420 for further
information.

### Upgrading from Previous Versions

If you are upgrading from a previous version (e.g., from Drupal 9):

1. **Backup your database** before proceeding
2. Update your Drupal core to version 10 or 11
3. Replace the module files with the new version
4. Run database updates: `drush updatedb` or visit `/update.php`
5. Clear all caches: `drush cache:rebuild`
6. Test the module functionality

For detailed upgrade instructions, see UPGRADE.txt in the module directory.


## CONFIGURATION

    1. Navigate to Administration > Extend and enable the Sign for
       acknowledgement module and its dependencies.
    2. Navigate to Administration > Configuration > People > Acknowledgement
       (/admin/config/people/acknowledge) to configure.
    3. Select the node types to be handled by the module.
    4. Choose whether to show a message when a node has no acknowledgement.
    5. Select the user and roles to support by default.
    6. Select the layout for display.
    7. Configure the email notifications.
    8. Save configurations.


## MAINTAINERS

 * Crescenzo Velleca (kris77) - https://www.drupal.org/u/kris77
