<?php

namespace Drupal\sign_for_acknowledgement\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Component\Utility\Xss;
use Drupal\Core\Form\FormBase;

/**
 * Form builder for the sign_for_acknowledgement alternate form.
 */
class AlternateForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'sign_for_acknowledgement_alt_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $node = NULL) {
    $user =  \Drupal::currentUser();
	
    $form['user'] = array(
      '#type' => 'value',
      '#name' => 'user',
      '#value' => $user->id(),
    );
    $form['node'] = array(
      '#type' => 'hidden',
      '#name' => 'node',
      '#value' => $node->id(),
    );
    // Check if annotation field should be displayed
    $do_ann = FALSE;
    $required = FALSE;
    
    if ($node->hasField('annotation_field')) {
      $ann_value = $node->get('annotation_field')->getValue();
      // Check explicitly for value === 1 or === '1' (checkbox checked)
      if (!empty($ann_value[0]['value']) && ($ann_value[0]['value'] == 1 || $ann_value[0]['value'] === TRUE)) {
        $do_ann = TRUE;
      }
    }
    
    if ($do_ann && $node->hasField('annotation_field_required')) {
      $req_value = $node->get('annotation_field_required')->getValue();
      // Check explicitly for value === 1 or === '1' (checkbox checked)
      if (!empty($req_value[0]['value']) && ($req_value[0]['value'] == 1 || $req_value[0]['value'] === TRUE)) {
        $required = TRUE;
      }
    }
    
    $multi = FALSE;
    if ($node->alternate_form_multiselect) {
      $multi = $node->alternate_form_multiselect->value;
    }
    $labels = str_replace(["\r\n", "\r"], "\n", $node->alternate_form_text->value);
    $labels = explode( "\n", $labels);//$node->get('alternate_form_text')->getValue();
    $options = array();
    foreach ($labels as $label) {
      $val = Xss::filter($label);
      if (empty(trim($val))) {
          continue;
      }
      $options[$val] = $val;
    }
    // Declaration/Agreement selection first
    $form['selection'] = array(
      '#type' => $multi? 'checkboxes' : 'radios',
      '#title' =>  $multi? t('Multiselect agreement') : t('Agreement'),
      '#options' => $options,
      //'#default_value' => 0,
      '#required' => TRUE,
      '#weight' => 10,
    );
    
    // Annotation field after declaration (if enabled)
    if ($do_ann) {
      $config = \Drupal::config('sign_for_acknowledgement.settings');
      $placeholder = $required 
        ? $config->get('annotation_placeholder_required') 
        : $config->get('annotation_placeholder');
      
      // Default placeholders if not configured
      if (empty($placeholder)) {
        $placeholder = $required
          ? t('Devi inserire il tuo orario di servizio il giorno dell\'assemblea/sciopero e/o informazioni utili per facilitare le sostituzioni')
          : t('Puoi inserire il tuo orario di servizio il giorno dell\'assemblea/sciopero per facilitare le sostituzioni');
      }
      
      $form['annotation'] = array(
        '#type' => 'textarea',
        '#title' => t('Annotation'),
        '#placeholder' => $placeholder,
        '#rows' => 4,
        '#cols' => 54,
        '#default_value' => '',
        '#resizable' => FALSE,
        '#required' => $required,
        '#attributes' => array('style' => 'width: 90%'),
        '#weight' => 20,
      );
    }
    
    $form['signature_submit'] = array(
      '#type' => 'submit',
      '#value' => t('Submit'),
      '#weight' => 30,
    );
    
    // Add custom CSS classes to submit button if configured
    $config = \Drupal::config('sign_for_acknowledgement.settings');
    $submit_classes = $config->get('submit_button_classes');
    if (!empty($submit_classes)) {
      // Parse classes and add them
      $classes = explode(' ', trim($submit_classes));
      $classes = array_filter($classes); // Remove empty values
      if (!empty($classes)) {
        if (!isset($form['signature_submit']['#attributes'])) {
          $form['signature_submit']['#attributes'] = array();
        }
        $form['signature_submit']['#attributes']['class'] = $classes;
      }
    }
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $dbman = \Drupal::service('sign_for_acknowledgement.db_manager');
    $userid = $form_state->getValue('user');
    $nodeid = $form_state->getValue('node');
    $select_val = $form_state->getValue('selection');
    if (is_array($select_val)) {
      $selection = '';
      foreach($select_val as $k => $val) {
        if ((string)$k !== (string)$val) {
          continue;
        }
        if (strlen($selection)) {
          $selection .= '|';
        }
        $selection .= $val;
      }
    }
    else { // single select
      $selection = $select_val;
    }
    if ($selection == '') {
      return FALSE;
    }
    $annotation = $form_state->getValue('annotation');
    if ($dbman->alternateSignDocument($userid, $nodeid, $selection, $annotation)) {
      $this->messenger()->addStatus(t('Document has been signed.'));
    }
  }
}
