<?php

namespace Drupal\sign_for_acknowledgement\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\FormBase;

/**
 * Form builder for the sign_for_acknowledgement basic checkbox form.
 */
class CheckboxForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'sign_for_acknowledgement_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $submit = FALSE, $node = NULL) {
    $user =  \Drupal::currentUser();
	
    $form['user'] = array(
      '#type' => 'value',
      '#name' => 'user',
      '#value' => $user->id(),
    );
    $form['node'] = array(
      '#type' => 'hidden',
      '#name' => 'node',
      '#value' => $node->id(),
    );
    // Check if annotation field should be displayed
    $do_ann = FALSE;
    $required = FALSE;
    
    if ($node->hasField('annotation_field')) {
      $ann_value = $node->get('annotation_field')->getValue();
      // Check explicitly for value === 1 or === '1' (checkbox checked)
      if (!empty($ann_value[0]['value']) && ($ann_value[0]['value'] == 1 || $ann_value[0]['value'] === TRUE)) {
        $do_ann = TRUE;
      }
    }
    
    if ($do_ann && $node->hasField('annotation_field_required')) {
      $req_value = $node->get('annotation_field_required')->getValue();
      // Check explicitly for value === 1 or === '1' (checkbox checked)
      if (!empty($req_value[0]['value']) && ($req_value[0]['value'] == 1 || $req_value[0]['value'] === TRUE)) {
        $required = TRUE;
      }
    }
    
    // Signature checkbox first
    $form['signature'] = array(
        '#type' => 'checkbox',
        '#required' => TRUE,
        '#attributes' => $submit ? NULL : array(
          'onclick' => 'this.form.submit()',
        ),
        '#title' => t('Click here to confirm you have read the document'),
        '#weight' => 10,
      );
    
    // Annotation field after signature (if enabled)
    if ($do_ann) {
      $config = \Drupal::config('sign_for_acknowledgement.settings');
      $placeholder = $required 
        ? $config->get('annotation_placeholder_required') 
        : $config->get('annotation_placeholder');
      
      // Default placeholders if not configured
      if (empty($placeholder)) {
        $placeholder = $required
          ? t('Devi inserire il tuo orario di servizio il giorno dell\'assemblea/sciopero e/o informazioni utili per facilitare le sostituzioni')
          : t('Puoi inserire il tuo orario di servizio il giorno dell\'assemblea/sciopero per facilitare le sostituzioni');
      }
      
      $form['annotation'] = array(
        '#type' => 'textarea',
        '#title' => t('Annotation'),
        '#placeholder' => $placeholder,
        '#rows' => 4,
        '#cols' => 54,
        '#default_value' => '',
        '#resizable' => FALSE,
        '#required' => $required,
        '#attributes' => array('style' => 'width: 90%'),
        '#weight' => 20,
      );
    }
    
    $form['signature_submit'] = array(
      '#type' => 'submit',
      '#value' => t('Submit'),
      '#attributes' => $submit ? NULL :  array(
        'style' => 'display:none',
      ),
      '#weight' => 30,
    );
    
    // Add custom CSS classes to submit button if configured
    $config = \Drupal::config('sign_for_acknowledgement.settings');
    $submit_classes = $config->get('submit_button_classes');
    if (!empty($submit_classes)) {
      // Parse classes and add them
      $classes = explode(' ', trim($submit_classes));
      $classes = array_filter($classes); // Remove empty values
      if (!empty($classes)) {
        if (!isset($form['signature_submit']['#attributes'])) {
          $form['signature_submit']['#attributes'] = array();
        }
        $form['signature_submit']['#attributes']['class'] = $classes;
      }
    }
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $dbman = \Drupal::service('sign_for_acknowledgement.db_manager');
    $userid = $form_state->getValue('user');
    $nodeid = $form_state->getValue('node');
    $checked = $form_state->getValue('signature');
    $annotation = $form_state->getValue('annotation');
    if (!$checked) {
      $this->messenger()->addWarning(t('Data not saved, please select the checkbox first.'));
      return;
    }
    if ($dbman->signDocument($userid, $nodeid, $annotation)) {
      $this->messenger()->addStatus(t('Document has been signed.'));
    }
  }
}
