<?php

namespace Drupal\Tests\acquia_contenthub_publisher\Functional;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Url;
use Drupal\node\Entity\Node;
use Drupal\Tests\BrowserTestBase;

/**
 * Tests CH export queue controller without csrf_token.
 *
 * @group acquia_contenthub_publisher
 *
 * @requires module depcalc
 *
 * @coversDefaultClass \Drupal\acquia_contenthub_publisher\Controller\ContentHubExportQueueController
 */
class ContentHubExportQueueControllerTest extends BrowserTestBase {

  /**
   * User that has administrator permission.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected AccountInterface $authorizedUser;

  /**
   * An entity.
   *
   * @var \Drupal\Core\Entity\EntityInterface
   */
  protected EntityInterface $entity;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'claro';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'system',
    'node',
    'user',
    'depcalc',
    'acquia_contenthub',
    'acquia_contenthub_publisher',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->authorizedUser = $this->drupalCreateUser(['administer acquia content hub', 'administer nodes']);
    $this->container->get('config.installer')->installDefaultConfig('module', 'acquia_contenthub_publisher');
    $this->drupalLogin($this->authorizedUser);

    $this->createContentType([
      'type' => 'article',
    ])->save();
    $this->entity = Node::create([
      'type' => 'article',
      'title' => 'Test Node',
    ]);
    $this->entity->save();
  }

  /**
   * Tests controller route directly.
   *
   * @throws \Behat\Mink\Exception\ExpectationException
   * @throws \Behat\Mink\Exception\ResponseTextException
   */
  public function testContentHubExportQueueControllerWithoutToken(): void {
    $entity_type = $this->entity->getEntityTypeId();
    $entity_uuid = $this->entity->uuid();

    $url = Url::fromRoute('acquia_contenthub_publisher.add_to_export_queue', [
      'entity_type' => $entity_type,
      'entity_uuid' => $entity_uuid,
    ]);

    $this->drupalGet($url);
    $this->assertSession()->statusCodeEquals(403);
  }

}
